/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.arrayManagers;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeKeyValue;
import com.vmware.vim.binding.vim.KeyValue;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyValueConverter.class);

    public static IeKeyValue[] fromVmodl(KeyValue[] keyValues) {
        if (ArrayUtils.isEmpty((Object[])keyValues)) {
            LOGGER.debug("KeyValues are null.");
            return new IeKeyValue[0];
        }
        return (IeKeyValue[])Arrays.stream(keyValues).map(keyValue -> new IeKeyValue(keyValue.key, keyValue.value)).toArray(IeKeyValue[]::new);
    }

    public static KeyValue[] toVmodl(IeKeyValue[] ieKeyValues) {
        if (ieKeyValues == null) {
            LOGGER.debug("IeKeyValues are null.");
            return null;
        }
        return (KeyValue[])Arrays.stream(ieKeyValues).map(ieKeyValue -> new KeyValue(ieKeyValue.getKey(), ieKeyValue.getValue())).toArray(KeyValue[]::new);
    }
}

