/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.common;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.common.IeRecoveryCallout;
import com.vmware.srm.client.impex.configurables.common.IeRecoveryCommand;
import com.vmware.srm.client.impex.configurables.common.IeRecoveryPrompt;
import com.vmware.srm.client.impex.configurables.common.RecoveryCommandConverter;
import com.vmware.srm.client.impex.configurables.common.RecoveryPromptConverter;
import com.vmware.vim.binding.dr.recovery.Callout;
import com.vmware.vim.binding.dr.recovery.Command;
import com.vmware.vim.binding.dr.recovery.Prompt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;

public class CalloutConverter
implements ConfigurableConverter {
    public static Callout[] toVmodl(List<IeRecoveryCallout> ieCallouts) {
        if (CollectionUtils.isEmpty(ieCallouts)) {
            return new Callout[0];
        }
        return (Callout[])ieCallouts.stream().filter(Objects::nonNull).map(ieCallout -> {
            if (ieCallout instanceof IeRecoveryCommand) {
                return RecoveryCommandConverter.toVmodl((IeRecoveryCommand)ieCallout);
            }
            return RecoveryPromptConverter.toVmodl((IeRecoveryPrompt)ieCallout);
        }).toArray(Callout[]::new);
    }

    public static List<IeRecoveryCallout> fromVmodl(Callout[] callouts) {
        if (ArrayUtils.isEmpty((Object[])callouts)) {
            return Collections.emptyList();
        }
        return Arrays.stream(callouts).filter(callout -> callout instanceof Command || callout instanceof Prompt).map(callout -> {
            if (callout instanceof Command) {
                return RecoveryCommandConverter.fromVmodl((Command)callout);
            }
            return RecoveryPromptConverter.fromVmodl((Prompt)callout);
        }).collect(Collectors.toList());
    }
}

