/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.groups;

import com.vmware.srm.client.impex.configurables.groups.IeSpProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.PgSettingsConverter;
import com.vmware.srm.client.impex.utils.GroupUtil;
import com.vmware.srm.client.impex.utils.MappingUtil;
import com.vmware.vim.binding.dr.replication.ProtectionGroup;
import com.vmware.vim.binding.dr.replication.StorageProfileProtectionGroup;
import com.vmware.vim.binding.dr.spAbrProvider.GroupSettings;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;

public class SpPgSettingsConverter
extends PgSettingsConverter {
    public static StorageProfileProtectionGroup.Settings toVmodl(IeSpProtectionGroup ieSpPg, ManagedObjectReference[] providers, Profile[] profiles) {
        StorageProfileProtectionGroup.Settings settings = new StorageProfileProtectionGroup.Settings();
        SpPgSettingsConverter.setBasicSettings((ProtectionGroup.Settings)settings, ieSpPg);
        String[] profileNames = ieSpPg.getProfiles();
        settings.setStorageProfile(SpPgSettingsConverter.getProfileIds(profiles, profileNames));
        ManagedObjectReference spAbrProvider = GroupUtil.getProvider(providers, "DrReplicationStorageProfileAbrProvider");
        StorageProfileProtectionGroup.ReplicationProviderGroupSettingsEntry entry = new StorageProfileProtectionGroup.ReplicationProviderGroupSettingsEntry();
        entry.setKey(spAbrProvider);
        entry.setValue((ProtectionGroup.ReplicationProviderGroupSettings)new GroupSettings());
        settings.setProviderSettingsMap(new StorageProfileProtectionGroup.ReplicationProviderGroupSettingsEntry[]{entry});
        return settings;
    }

    private static ProfileId[] getProfileIds(Profile[] profiles, String[] profileNames) {
        if (profiles == null || profileNames == null) {
            return null;
        }
        Object[] profileIds = (ProfileId[])Arrays.stream(profileNames).map(profile -> MappingUtil.getProfileId(profiles, profile)).filter(Objects::nonNull).map(ProfileId::new).toArray(ProfileId[]::new);
        return ArrayUtils.isEmpty((Object[])profileIds) ? null : profileIds;
    }
}

