/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.mappings;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.mappings.FolderMappingsConverter;
import com.vmware.srm.client.impex.configurables.mappings.IeMappings;
import com.vmware.srm.client.impex.configurables.mappings.IeNetworkMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeStorageProfileMapping;
import com.vmware.srm.client.impex.configurables.mappings.InventoryTestNetworkMappingConverter;
import com.vmware.srm.client.impex.configurables.mappings.ResourcePoolMappingsConverter;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;

public class MappingsConverter
implements ConfigurableConverter {
    public static PropertyCollector.FilterSpec getFilterSpec(ManagedObjectReference remoteSite) {
        PropertyCollector.PropertySpec localMappingsSpec = PCUtil.createPropertySpec((String)"DrInventoryMapper", (String[])new String[]{"folderMappings", "networkMappings", "resourcePoolMappings", "testNetworkMappings", "storageProfileMappings"});
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(remoteSite);
        specBuilder.traverseTo("inventoryMapper");
        return new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{localMappingsSpec}, new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
    }

    public static IeMappings fromVmodl(InventoryMapperBase.FolderMapping[] folders, InventoryMapperBase.ResourcePoolMapping[] resources, InventoryMapperBase.TestNetworkMapping[] testNetworks, boolean local, IeNetworkMapping[] convertedNetworks, IeStorageProfileMapping[] convertedStorageProfiles) {
        IeMappings mappings = new IeMappings();
        mappings.setNetworks(convertedNetworks);
        mappings.setFolders(FolderMappingsConverter.fromVmodl(folders));
        mappings.setResources(ResourcePoolMappingsConverter.fromVmodl(resources));
        mappings.setStorageProfiles(convertedStorageProfiles);
        mappings.setTestNetworks(InventoryTestNetworkMappingConverter.fromVmodl(testNetworks));
        mappings.setLocal(local);
        return mappings;
    }

    public static ManagedObjectReference getInventoryMapper(PcResult pcResult, String type) {
        return pcResult.getMoRefs().stream().filter(moRef -> type.equals(moRef.getType())).findFirst().orElseThrow(IllegalStateException::new);
    }
}

