/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.folders;

import com.vmware.srm.client.impex.configurables.Configurable;
import com.vmware.srm.client.impex.configurables.folders.IeFolder;
import com.vmware.srm.client.impex.configurables.groups.IeProtectionGroup;
import com.vmware.srm.client.impex.exporters.Exporter;
import com.vmware.srm.client.impex.exporters.groups.ProtectionGroupsExporter;
import com.vmware.srm.client.impex.exporters.groups.SpProtectionGroupsExporter;
import com.vmware.srm.client.impex.exporters.groups.VmProtectionGroupsExporter;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.utils.GroupUtil;
import com.vmware.srm.client.impex.utils.MappingUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.pbm.SpbmService;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectionGroupFoldersExporter
extends Exporter<IeFolder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtectionGroupFoldersExporter.class);

    @Override
    public Promise<List<IeFolder>> getConfigurables() {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        ManagedObjectReference rootFolderMoRef = ClientUtils.createMoRef((String)"DrFolder", (String)"DrReplicationRootFolder", (String)((SrmServer)serversData.getLocalPair().server()).guid());
        ManagedObjectReference storageManager = serversData.getLocalContent().storageManager;
        SpbmService localSpbmService = ((SrmServer)serversData.getLocalPair().server()).vc().spbmService();
        SpbmService remoteSpbmService = ((SrmServer)serversData.getRemotePair().server()).vc().spbmService();
        Promise<PcResult> protectionGroups = GroupUtil.getProtectionGroups((ServersView)serversData.getView(), rootFolderMoRef, storageManager);
        Promise<Profile[]> localProfilesPromise = MappingUtil.getProfiles(localSpbmService);
        Promise<Profile[]> remoteProfilesPromise = MappingUtil.getProfiles(remoteSpbmService);
        Promise<DomainInfo[]> localDomainInfosPromise = GroupUtil.getDomainInfos(true);
        Promise<DomainInfo[]> remoteDomainInfosPromise = GroupUtil.getDomainInfos(false);
        return Promises.all((Promise[])new Promise[]{protectionGroups, localProfilesPromise, remoteProfilesPromise, localDomainInfosPromise, remoteDomainInfosPromise}).thenApply(resultAccessor -> {
            PcResult pcResult = (PcResult)resultAccessor.getResult(protectionGroups);
            Profile[] localProfiles = (Profile[])resultAccessor.getResult(localProfilesPromise);
            Profile[] remoteProfiles = (Profile[])resultAccessor.getResult(remoteProfilesPromise);
            DomainInfo[] localDomainInfos = (DomainInfo[])resultAccessor.getResult(localDomainInfosPromise);
            DomainInfo[] remoteDomainInfos = (DomainInfo[])resultAccessor.getResult(remoteDomainInfosPromise);
            IeFolder ieRoot = new IeFolder();
            String name = (String)pcResult.getProperty(rootFolderMoRef, "name");
            ieRoot.setName(name);
            List<Configurable> children = this.getChildren(rootFolderMoRef, pcResult, new SpProtectionGroupsExporter(pcResult, localProfiles, remoteProfiles), new VmProtectionGroupsExporter(pcResult, localDomainInfos, remoteDomainInfos));
            ieRoot.setChildren(children);
            return Collections.singletonList(ieRoot);
        });
    }

    private List<Configurable> getChildren(ManagedObjectReference parent, PcResult pcResult, ProtectionGroupsExporter sppgExporter, ProtectionGroupsExporter vmpgExporter) {
        ManagedObjectReference[] childrenMoRefs = (ManagedObjectReference[])pcResult.getProperty(parent, "childEntity");
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return Arrays.stream(childrenMoRefs).map(child -> {
            String type;
            switch (type = child.getType()) {
                case "DrFolder": {
                    List<Configurable> grandChildren = this.getChildren((ManagedObjectReference)child, pcResult, sppgExporter, vmpgExporter);
                    IeFolder ieFolder = new IeFolder();
                    String name = (String)pcResult.getProperty(child, "name");
                    ieFolder.setName(name);
                    ieFolder.setChildren(grandChildren);
                    return ieFolder;
                }
                case "DrReplicationVmProtectionGroup": {
                    Object ieVmPg = vmpgExporter.convertProtectionGroup((ManagedObjectReference)child);
                    ((IeProtectionGroup)ieVmPg).setId(idBuilder.buildId((ManagedObjectReference)child));
                    return ieVmPg;
                }
                case "DrReplicationStorageProfileProtectionGroup": {
                    Object ieSpPg = sppgExporter.convertProtectionGroup((ManagedObjectReference)child);
                    ((IeProtectionGroup)ieSpPg).setId(idBuilder.buildId((ManagedObjectReference)child));
                    return ieSpPg;
                }
            }
            LOGGER.error("Parent '{}' has child: '{}' with unexpected type.", (Object)parent, child);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

