/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.arrayManagers;

import com.vmware.srm.client.impex.configurables.arrayManagers.ArrayManagerConverter;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeArrayManager;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeStorageAdapter;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.StorageAdapterUtil;
import com.vmware.srm.client.impex.utils.TaskUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.dr.storage.AdapterConnectionSpec;
import com.vmware.vim.binding.dr.storage.StorageManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayManagerImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayManagerImporter.class);

    public Promise<ManagedObjectReference> create(IeArrayManager ieArrayManager, String username, String password) {
        LOGGER.info("Creating array manager '{}'.", (Object)ieArrayManager.getName());
        IeStorageAdapter ieAdapter = ieArrayManager.getStorageAdapter();
        if (ieAdapter == null) {
            return Promises.reject((Exception)new RuntimeException("No storage adapter for array manager: " + ieArrayManager.getName()));
        }
        boolean local = ieArrayManager.isLocal();
        Promise<Map<String, ManagedObjectReference>> adapterMapPromise = StorageAdapterUtil.getSANameToMoRef((ServersView)IContextUtil.getSrmView(), IContextUtil.getSrmContent((boolean)local).storageManager);
        return adapterMapPromise.thenApply(adapterMap -> this.getStorageAdapterRef(ieAdapter, (Map<String, ManagedObjectReference>)adapterMap)).thenCompose(adapter -> {
            Object[] connectionSpec = ArrayManagerConverter.connectionSpecToVmodl(ieArrayManager.getConnectionSpec(), username, password, ieArrayManager.getName());
            if (ArrayUtils.isEmpty((Object[])connectionSpec)) {
                return Promises.reject((Exception)new IllegalArgumentException("ConnectionSpec"));
            }
            return this.createArrayManager(ieArrayManager, local, (ManagedObjectReference)adapter, (AdapterConnectionSpec[])connectionSpec);
        }).thenCompose(taskMoRef -> TaskUtil.monitorTask(IContextUtil.getSrmService(local), taskMoRef)).onSuccess(arrayManagerMoRef -> LOGGER.info("Array manager '{}' was created successfully.", (Object)ieArrayManager.getName())).onError(error -> LOGGER.warn("Failed to create array manager '{}'.", (Object)ieArrayManager.getName(), error));
    }

    private ManagedObjectReference getStorageAdapterRef(IeStorageAdapter ieAdapter, Map<String, ManagedObjectReference> adapterMap) {
        String adapterName = ieAdapter.getName();
        ManagedObjectReference adapter = adapterMap.get(adapterName);
        if (adapter == null) {
            throw new RuntimeException("No adapter ref for: " + adapterName);
        }
        return adapter;
    }

    private Promise<ManagedObjectReference> createArrayManager(IeArrayManager ieArrayManager, boolean local, ManagedObjectReference adapter, AdapterConnectionSpec[] connectionSpec) {
        StorageManager storageManager = (StorageManager)IContextUtil.getSrmService(local).createStub(IContextUtil.getSrmContent((boolean)local).storageManager);
        FuturePromise taskMoRefPromise = new FuturePromise();
        storageManager.createArrayManager(ieArrayManager.getName(), adapter, connectionSpec, (Future)taskMoRefPromise);
        return taskMoRefPromise;
    }
}

