/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.srm.client.impex.configurables.Configurable;
import com.vmware.srm.client.impex.configurables.InventoryNames;
import com.vmware.srm.client.impex.configurables.folders.IeFolder;
import com.vmware.srm.client.impex.configurables.groups.IeProtectionGroup;
import com.vmware.srm.client.impex.configurables.inventory.IeInventory;
import com.vmware.srm.client.impex.configurables.inventory.IeInventoryFolder;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeDatacenter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeDatastore;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeNetwork;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeResourcePool;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeVirtualMachine;
import com.vmware.srm.client.impex.tool.ConfigurablesWrapper;
import java.util.List;

public class InventoryUtil {
    public static InventoryNames getInventoryNames(ConfigurablesWrapper configurablesWrapper) {
        InventoryNames items = new InventoryNames();
        configurablesWrapper.getInventory().forEach(inventory -> InventoryUtil.parseInventory(inventory.getRoot(), items));
        InventoryUtil.parseGroups(configurablesWrapper.getProtectionGroupRootFolder().getChildren(), items);
        return items;
    }

    private static void parseInventory(IeInventory item, InventoryNames items) {
        if (item instanceof IeInventoryFolder) {
            List<IeInventory> children = ((IeInventoryFolder)item).getChildren();
            if (children != null) {
                children.forEach(child -> InventoryUtil.parseInventory(child, items));
            }
        } else if (item instanceof IeResourcePool) {
            List<IeResourcePool> children;
            IeResourcePool resourcePool = (IeResourcePool)item;
            List<IeVirtualMachine> vms = resourcePool.getVirtualMachines();
            if (vms != null) {
                vms.forEach(vm -> InventoryUtil.parseInventory(vm, items));
            }
            if ((children = resourcePool.getChildren()) != null) {
                children.forEach(child -> InventoryUtil.parseInventory(child, items));
            }
        } else if (item instanceof IeVirtualMachine) {
            items.putVm(item.getId(), item.getName());
        } else if (item instanceof IeDatacenter) {
            List<IeNetwork> networks;
            IeDatacenter datacenter = (IeDatacenter)item;
            List<IeDatastore> datastores = datacenter.getDatastores();
            if (datastores != null) {
                datastores.forEach(datastore -> items.putDatastore(datastore.getId(), datastore.getName()));
            }
            if ((networks = datacenter.getNetworks()) != null) {
                networks.forEach(network -> items.putNetwork(network.getId(), network.getName()));
            }
            InventoryUtil.parseInventory(datacenter.getVmFolder(), items);
        }
    }

    private static void parseGroups(List<? extends Configurable> children, InventoryNames items) {
        if (children == null) {
            return;
        }
        for (Configurable configurable : children) {
            if (configurable instanceof IeFolder) {
                InventoryUtil.parseGroups(((IeFolder)configurable).getChildren(), items);
                continue;
            }
            if (!(configurable instanceof IeProtectionGroup)) continue;
            IeProtectionGroup pg = (IeProtectionGroup)configurable;
            items.putPg(pg.getId(), pg.getName());
        }
    }
}

