/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfigurationCompiler;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifierExt;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.KeyManagerWrapper;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vim.vmomi.client.http.util.VecsUtils;
import com.vmware.vim.vmomi.core.util.ClassUtil;
import com.vmware.vim.vmomi.core.util.FileUtil;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HttpConfigurationCompilerBase
implements HttpConfigurationCompiler {
    private static final Log LOG = LogFactory.getLog(HttpConfigurationCompilerBase.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompiledHttpConfiguration compile(HttpClientConfiguration clientConfig) {
        HttpConfigurationImpl configImpl;
        HttpConfiguration config = clientConfig.getHttpConfiguration();
        HttpConfigurationImpl httpConfigurationImpl = configImpl = (HttpConfigurationImpl)config;
        synchronized (httpConfigurationImpl) {
            CompiledHttpConfiguration result = configImpl.getCompiledConfiguration();
            if (result != null && result.isActive()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Compile configuration is active, reusing: CompiledHttpConfiguration@" + result.hashCode()));
                }
                return result;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Compiling HttpConfiguration:\n" + configImpl));
            }
            result = this.doCompile(configImpl);
            configImpl.resetCompiledConfiguration();
            configImpl.setCompiledConfiguration(result);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created new CompiledHttpConfiguration@" + result.hashCode()));
            }
            return result;
        }
    }

    protected abstract CompiledHttpConfiguration doCompile(HttpConfiguration var1);

    protected KeyManager[] createKeyManagers(HttpConfiguration config) {
        String password = config.getKeyStoreConfig().getKeyPassword();
        String alias = config.getKeyStoreConfig().getKeyAlias();
        try {
            if (password != null && alias != null) {
                KeyStore store = this.loadKeyStore(config);
                KeyManagerFactory keyMngrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyMngrFactory.init(store, password.toCharArray());
                KeyManager[] keyManagers = keyMngrFactory.getKeyManagers();
                for (int i = 0; i < keyManagers.length; ++i) {
                    if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                    keyManagers[i] = new KeyManagerWrapper((X509KeyManager)keyManagers[i], alias);
                }
                return keyManagers;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create KeyManagers", e);
        }
        return null;
    }

    protected KeyStore loadTrustStore(HttpConfiguration config) {
        KeyStore vecsTrustStore = VecsUtils.getVecsTrustStore();
        if (vecsTrustStore != null) {
            return vecsTrustStore;
        }
        if (config.getTrustStore() != null) {
            return config.getTrustStore();
        }
        String trustStorePath = config.getKeyStoreConfig().getTrustStorePath();
        if (trustStorePath == null) {
            return null;
        }
        return this.createKeyStore(trustStorePath, config.getKeyStoreConfig().getTrustStorePassword(), "JKS");
    }

    private CertStore loadCrlCertStore(HttpConfiguration config) {
        CertStore result = null;
        result = VecsUtils.getVecsCertStore();
        if (result == null) {
            result = config.getCrlCertStore();
        }
        return result;
    }

    protected KeyStore loadKeyStore(HttpConfiguration config) {
        if (config.getKeyStore() != null) {
            return config.getKeyStore();
        }
        return this.createKeyStore(config.getKeyStoreConfig().getKeyStorePath(), config.getKeyStoreConfig().getKeyStorePassword(), config.getKeyStoreConfig().getKeyStoreType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createKeyStore(String path, String password, String type) {
        try {
            KeyStore keyStore = KeyStore.getInstance(type.toUpperCase());
            if (path != null && password != null) {
                ClassLoader loader = ClassUtil.getCurrentClassLoader();
                try (InputStream stream = FileUtil.getInputStream((String)path, (ClassLoader)loader);){
                    keyStore.load(stream, password.toCharArray());
                }
            } else {
                keyStore.load(null);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create default client trust/key store", e);
        }
    }

    protected ThumbprintVerifier createThumbprintVerifier(HttpConfiguration config) {
        return config.getThumbprintVerifier();
    }

    private ThumbprintVerifierExt extendVerifier(final ThumbprintVerifier verifier) {
        if (verifier == null) {
            return null;
        }
        if (verifier instanceof ThumbprintVerifierExt) {
            return (ThumbprintVerifierExt)verifier;
        }
        return new ThumbprintVerifierExt(){

            @Override
            public ThumbprintVerifier.Result verify(String thumbprint) {
                return verifier.verify(thumbprint);
            }

            @Override
            public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertions) throws SSLException {
                verifier.onSuccess(chain, thumbprint, verifyResult, trustedChain, verifiedAssertions);
            }

            @Override
            public String getDigestAlgorithm() {
                return "SHA-1";
            }
        };
    }

    protected ThumbprintTrustManager createThumbprintTrustManager(HttpConfiguration config) {
        return new ThumbprintTrustManager(this.loadTrustStore(config), this.loadCrlCertStore(config), this.extendVerifier(this.createThumbprintVerifier(config)));
    }

    protected SSLContext createSSLContext(HttpConfiguration config, ThumbprintTrustManager trustManager) {
        SSLContext sslContext = null;
        KeyManager[] keyManagers = this.createKeyManagers(config);
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalException("Unable to create SSLContext", e);
        }
        catch (KeyManagementException e) {
            throw new InternalException("Unable to create SSLContext", e);
        }
        return sslContext;
    }
}

