/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client.impl.processors.response;

import com.vmware.identity.wstrust.client.exception.InternalError;
import com.vmware.identity.wstrust.client.impl.exception.ParserException;
import com.vmware.identity.wstrust.client.impl.processors.response.ResponseHandlerImpl;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.MalformedTokenException;
import javax.xml.bind.JAXBContext;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenResponseType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExtractTokenResponseHandler
extends ResponseHandlerImpl<Element> {
    public ExtractTokenResponseHandler(JAXBContext context) throws InternalError {
        super(context);
    }

    @Override
    public Element parseResponse(Node response) throws ParserException, InvalidTokenException {
        return this.extractTokenFromResponse(response);
    }

    private Element extractTokenFromResponse(Node response) throws ParserException, InvalidTokenException {
        RequestSecurityTokenResponseType parsedResponse = this.parseStsResponse(response);
        if (parsedResponse == null) {
            throw new MalformedTokenException("Unable to find a response to the token request");
        }
        if (!"urn:oasis:names:tc:SAML:2.0:assertion".equalsIgnoreCase(parsedResponse.getTokenType())) {
            String message = "Unexpected token type value in the response. Got: " + parsedResponse.getTokenType() + " Expected: " + "urn:oasis:names:tc:SAML:2.0:assertion";
            throw new MalformedTokenException(message);
        }
        return (Element)response.getOwnerDocument().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
    }
}

