/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client.impl.processors.response;

import com.vmware.identity.token.impl.SamlTokenImpl;
import com.vmware.identity.token.impl.Util;
import com.vmware.identity.wstrust.client.exception.InternalError;
import com.vmware.identity.wstrust.client.impl.ResponseHandler;
import com.vmware.identity.wstrust.client.impl.exception.ParserException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenResponseCollectionType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class ResponseHandlerImpl<ResponseType>
implements ResponseHandler<ResponseType> {
    protected static final String TOKEN_TYPE_SAML2 = "urn:oasis:names:tc:SAML:2.0:assertion";
    protected static final String ASSERTION_ELEMENT_NAME = "Assertion";
    private static final String ERR_LOADING_WS_TRUST_SCHEMA = "Error loading WS-Trust schema file";
    private final Logger _log = LoggerFactory.getLogger(ResponseHandlerImpl.class);
    private static final String WS_TRUST_1_3_SCHEMA = "vmware-ws-trust-1.3.xsd";
    private static Schema _wsTrustSchema = ResponseHandlerImpl.loadWsTrustSchema();
    private final JAXBContext _jaxbContext;

    public ResponseHandlerImpl(JAXBContext context) throws InternalError {
        if (_wsTrustSchema == null) {
            throw new InternalError(ERR_LOADING_WS_TRUST_SCHEMA);
        }
        assert (context != null);
        this._jaxbContext = context;
    }

    protected final RequestSecurityTokenResponseType parseStsResponse(Node soapResponseNode) throws ParserException {
        return this.parseStsResponse(soapResponseNode, RequestSecurityTokenResponseCollectionType.class, false).getRequestSecurityTokenResponse();
    }

    protected final <StsResponseType> StsResponseType parseStsResponse(Node soapResponseNode, Class<StsResponseType> responseType, boolean skipValidation) throws ParserException {
        JAXBElement jaxbParserResult;
        try {
            Unmarshaller unmarshaller = this._jaxbContext.createUnmarshaller();
            if (!skipValidation) {
                unmarshaller.setSchema(_wsTrustSchema);
            }
            jaxbParserResult = unmarshaller.unmarshal(soapResponseNode, responseType);
        }
        catch (JAXBException e) {
            String message = "Error parsing the response document";
            this._log.debug(message);
            throw new ParserException(message, e);
        }
        this._log.debug("Parsing the responce object to JAXB classes completed");
        return (StsResponseType)jaxbParserResult.getValue();
    }

    private static Schema loadWsTrustSchema() {
        try {
            Schema wsTrustSchema = Util.loadXmlSchemaFromResource(ResponseHandlerImpl.class, (String)WS_TRUST_1_3_SCHEMA);
            return wsTrustSchema;
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(SamlTokenImpl.class).error(String.format("Schema resource `%s' is missing.", WS_TRUST_1_3_SCHEMA), (Throwable)e);
            throw new RuntimeException(String.format("Schema resource `%s' is missing.", WS_TRUST_1_3_SCHEMA), e);
        }
        catch (SAXException e) {
            LoggerFactory.getLogger(ResponseHandlerImpl.class).error(ERR_LOADING_WS_TRUST_SCHEMA, (Throwable)e);
            throw new RuntimeException(ERR_LOADING_WS_TRUST_SCHEMA, e);
        }
    }
}

