/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.reactive;

import com.vmware.srm.client.reactive.impl.utils.Exceptions;
import org.apache.commons.lang.Validate;

public class PromiseResult<T> {
    private final T _result;
    private final Exception _exception;
    private final boolean _isSuccessful;

    public static <T> PromiseResult<T> fromResult(T result) {
        return new PromiseResult<T>(result);
    }

    public static <T> PromiseResult<T> fromException(Throwable error) {
        Validate.notNull((Object)error, (String)"error");
        return new PromiseResult<T>(Exceptions.wrap(error));
    }

    public static <T> PromiseResult<T> fromAny(T result, Throwable error) {
        if (error == null) {
            return PromiseResult.fromResult(result);
        }
        return PromiseResult.fromException(error);
    }

    private PromiseResult(T result) {
        this._result = result;
        this._isSuccessful = true;
        this._exception = null;
    }

    private PromiseResult(Exception exception) {
        this._result = null;
        this._isSuccessful = false;
        this._exception = exception;
    }

    public boolean isSuccessful() {
        return this._isSuccessful;
    }

    public T getResult() {
        if (!this.isSuccessful()) {
            throw new IllegalStateException("Failed operation.");
        }
        return this._result;
    }

    public Exception getError() {
        return this._exception;
    }
}

