/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.Environment;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContextFactory;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

class ArrayStackContext
extends StackContext {
    private ArrayList<Object> _value;
    private VmodlField _componentField;
    private Environment _env;

    public ArrayStackContext(VmodlField field, VmodlType type, StackContext parent, Environment env) {
        super(field, type, parent);
        this._env = env;
        VmodlArrayType arrayType = (VmodlArrayType)type;
        VmodlType componentType = arrayType.getComponentType();
        this._componentField = field.getType().getKind() == VmodlType.Kind.ANY ? new ArrayComponentField(field, componentType, componentType.getWsdlName()) : new ArrayComponentField(field, componentType, field.getName());
        this._value = new ArrayList();
    }

    @Override
    public void setValue(Object value) throws UnmarshallException {
        throw new UnmarshallException(String.format("Array contains illegal content: '%1$s'", value));
    }

    @Override
    public void setChildValue(VmodlField field, Object value) throws UnmarshallException {
        if (this._componentField != field) {
            throw new UnmarshallException(String.format("Unsupported child value for field '%1$s'", field.getName()));
        }
        this._value.add(value);
    }

    @Override
    public void close() throws UnmarshallException {
        StackContext parent = this.getParentContext();
        if (parent != null) {
            parent.setChildValue(this.getField(), this.getValue());
        }
    }

    @Override
    public StackContext getNestedContext(QName name2, Map<QName, String> attrs, NamespaceContext namespaces) throws UnmarshallException {
        if (!name2.getLocalPart().equals(this._componentField.getName())) {
            return null;
        }
        return StackContextFactory.newContext(this, this._componentField, name2, attrs, namespaces, this._env);
    }

    @Override
    public Object getValue() {
        Object out = null;
        VmodlArrayType arrType = (VmodlArrayType)this.getType();
        VmodlType componentType = arrType.getComponentType();
        out = this._env.isResolveMoType() && componentType.getKind() == VmodlType.Kind.MOREF ? Array.newInstance(ManagedObject.class, this._value.size()) : arrType.newInstance(this._value.size());
        for (int i = 0; i < this._value.size(); ++i) {
            Array.set(out, i, this._value.get(i));
        }
        return out;
    }

    static class ArrayComponentField
    implements VmodlField {
        private VmodlField _arrayField;
        private VmodlType _componentType;
        private String _fieldName;

        public ArrayComponentField(VmodlField arrayField, VmodlType componentType, String fieldName) {
            this._arrayField = arrayField;
            this._componentType = componentType;
            this._fieldName = fieldName;
        }

        @Override
        public String getName() {
            return this._fieldName;
        }

        @Override
        public String getWsdlName() {
            return this._fieldName;
        }

        @Override
        public VmodlType getType() {
            return this._componentType;
        }

        @Override
        public VmodlVersion getVersion() {
            return this._arrayField.getVersion();
        }

        @Override
        public String GetPrivilegeId() {
            return this._arrayField.GetPrivilegeId();
        }

        @Override
        public boolean isOptional() {
            return this._arrayField.isOptional();
        }

        @Override
        public VmodlType getManagedObjectType() {
            return this._arrayField.getManagedObjectType();
        }

        @Override
        public boolean isLink() {
            return this._arrayField.isLink();
        }

        @Override
        public boolean isLinkable() {
            return this._arrayField.isLinkable();
        }

        @Override
        public boolean isVisible(VmodlVersion version) {
            return this._arrayField.isVisible(version);
        }

        @Override
        public VmodlType getLinkType() {
            return this._arrayField.getLinkType();
        }

        @Override
        public boolean isSecret() {
            return this._arrayField.isSecret();
        }

        @Override
        public VmodlField.CollectionType getCollectionType() {
            return VmodlField.CollectionType.NONE;
        }
    }
}

