/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.impl.vmodl.MethodNameImpl;
import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.subprivilege;
import com.vmware.vim.binding.vmodl.subprivileges;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.Util;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmomiService;
import com.vmware.vim.vmomi.core.types.impl.VmodlContextImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlFieldImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ManagedMethodImpl
implements ManagedMethod {
    private final ManagedObjectType _managedObjectType;
    private String _name;
    private String _wsdlName;
    private MethodName _methodName;
    private String _privilegeId;
    private VmodlField[] _parameters;
    private VmodlType _result;
    private VmodlVersion _version;
    private VmodlType[] _faults;
    private HashMap<String, VmodlType> _faultMap;
    private boolean _internal;
    private boolean _isTask;
    private Method _method;
    private VmodlField _returnField;
    private ManagedProperty _managedProperty;

    public ManagedMethodImpl(ManagedObjectType managedObjectType2, Method method) {
        this._managedObjectType = managedObjectType2;
        this.init(method);
    }

    public static VmodlType resolveFutureType(Type type, VmodlContext context) {
        Class<?> specialization;
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if ((type = parameterizedType.getActualTypeArguments()[0]) instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            type = arrayType.getGenericComponentType();
            specialization = Array.newInstance((Class)type, 0).getClass();
        } else {
            specialization = (Class<?>)type;
        }
        if (specialization == Void.class) {
            return null;
        }
        VmodlType vmodlResultType = context.getVmodlTypeMap().getVmodlType(specialization);
        if (vmodlResultType == null) {
            throw new IllegalStateException(String.format("Unable to resolve result type of class %1$s", specialization));
        }
        return vmodlResultType;
    }

    private void init(Method method) {
        HashMap<Class, Annotation> annotationMap;
        VmodlContext context = this._managedObjectType.getVmodlContext();
        VmodlTypeMap typeMap = context.getVmodlTypeMap();
        this._name = method.getName();
        this._method = method;
        wsdlName wsdlAnnotation = method.getAnnotation(wsdlName.class);
        this._wsdlName = wsdlAnnotation != null ? wsdlAnnotation.value() : this._name;
        privilege privAnnotation = method.getAnnotation(privilege.class);
        if (privAnnotation != null) {
            this._privilegeId = privAnnotation.value();
        } else {
            subprivileges subprivs = method.getAnnotation(subprivileges.class);
            if (subprivs != null) {
                for (subprivilege subpriv : subprivs.value()) {
                    if (!subpriv.className().equals(this._managedObjectType.getTypeClass().getName())) continue;
                    this._privilegeId = subpriv.privilegeId();
                }
            }
        }
        this._isTask = method.getAnnotation(task.class) != null;
        this._version = context.getVmodlVersionMap().getVersion(method.getAnnotation(versionClass.class).value());
        boolean isAsync = false;
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterCount = parameterTypes.length;
        if (parameterCount > 0 && parameterTypes[parameterTypes.length - 1] == Future.class) {
            isAsync = true;
            --parameterCount;
        }
        ArrayList<VmodlFieldImpl> parameters = new ArrayList<VmodlFieldImpl>();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterCount; ++i) {
            versionClass paramVersionAnnotation;
            Class<?> paramClass = parameterTypes[i];
            VmodlType vmodlType = typeMap.getVmodlType(paramClass);
            if (vmodlType == null) {
                throw new IllegalStateException("Unable to resolve type of method " + this._name + " parameter type " + paramClass.getName());
            }
            annotationMap = Util.mapAnnotations(annotations[i]);
            VmodlFieldImpl field = new VmodlFieldImpl(context);
            field.setType(vmodlType);
            name nameAnnotation = (name)annotationMap.get(name.class);
            if (nameAnnotation == null) {
                throw new IllegalStateException("Parameter " + (i + 1) + " of method " + this._name + " does not have a @name annotation");
            }
            field.setName(nameAnnotation.value());
            wsdlName paramWsdlNameAnnotation = (wsdlName)annotationMap.get(wsdlName.class);
            if (paramWsdlNameAnnotation != null) {
                field.setWsdlName(paramWsdlNameAnnotation.value());
            } else {
                field.setWsdlName(nameAnnotation.value());
            }
            privilege paramPrivAnnotation = (privilege)annotationMap.get(privilege.class);
            if (paramPrivAnnotation != null) {
                field.setPrivilegeId(paramPrivAnnotation.value());
            }
            if ((paramVersionAnnotation = (versionClass)annotationMap.get(versionClass.class)) != null) {
                field.setVersion(context.getVmodlVersionMap().getVersion(paramVersionAnnotation.value()));
            } else {
                field.setVersion(this._version);
            }
            managedObjectType moTypeAnnotation = (managedObjectType)annotationMap.get(managedObjectType.class);
            if (moTypeAnnotation != null) {
                field.setManagedObjectClassName(moTypeAnnotation.value());
            }
            field.setOptional(annotationMap.get(optional.class) != null);
            field.setSecret(annotationMap.get(secret.class) != null);
            field.setCollectionType(Util.computeCollectionType(annotationMap));
            parameters.add(field);
        }
        this._parameters = parameters.toArray(new VmodlField[parameters.size()]);
        try {
            managedObjectType moTypeAnnotation;
            String managedObjectClassName;
            if (isAsync) {
                this._result = ManagedMethodImpl.resolveFutureType(method.getGenericParameterTypes()[parameterTypes.length - 1], context);
                HashMap<Class, Annotation> annotationMap2 = Util.mapAnnotations(annotations[parameterTypes.length - 1]);
                managedObjectClassName = null;
                moTypeAnnotation = (managedObjectType)annotationMap2.get(managedObjectType.class);
                if (moTypeAnnotation != null) {
                    managedObjectClassName = moTypeAnnotation.value();
                }
                VmodlField.CollectionType collectionType = Util.computeCollectionType(annotationMap2);
                this._returnField = new MethodReturnField(annotationMap2.get(optional.class) != null, annotationMap2.get(secret.class) != null, collectionType, managedObjectClassName, context);
            } else {
                Class<?> returnType = method.getReturnType();
                this._result = typeMap.getVmodlType(returnType);
                if (this._result == null && returnType != Void.TYPE) {
                    throw new IllegalStateException("return type not found in vmodl type map");
                }
                managedObjectClassName = null;
                moTypeAnnotation = method.getAnnotation(managedObjectType.class);
                if (moTypeAnnotation != null) {
                    managedObjectClassName = moTypeAnnotation.value();
                }
                annotationMap = Util.mapAnnotations(method.getAnnotations());
                VmodlField.CollectionType collectionType = Util.computeCollectionType(annotationMap);
                this._returnField = new MethodReturnField(method.getAnnotation(optional.class) != null, method.getAnnotation(secret.class) != null, collectionType, managedObjectClassName, context);
            }
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Unable to resolve result type of method " + this._name + " of managed object type " + this._managedObjectType.getTypeClass().getName(), e);
        }
        this._faultMap = new HashMap();
        ArrayList<VmodlType> faults2 = new ArrayList<VmodlType>();
        faults faultsAnnotation = method.getAnnotation(faults.class);
        if (faultsAnnotation != null) {
            VmomiService service2 = this._version == null ? null : this._version.getService();
            for (String faultName : faultsAnnotation.value()) {
                VmodlType faultType = typeMap.getVmodlType(faultName, service2);
                if (faultType == null) {
                    faultType = typeMap.getVmodlType(faultName);
                }
                if (faultType == null) {
                    throw new IllegalStateException("Unable to resolve type of method " + this._name + " declared fault " + faultName);
                }
                faults2.add(faultType);
                this._faultMap.put(faultName, faultType);
            }
        }
        this._faults = faults2.toArray(new VmodlType[faults2.size()]);
        this._internal = method.getAnnotation(internal.class) != null;
        this._methodName = new MethodNameImpl(this);
    }

    @Override
    public ManagedObjectType getManagedObjectType() {
        return this._managedObjectType;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getWsdlName() {
        return this._wsdlName;
    }

    @Override
    public MethodName getMethodName() {
        return this._methodName;
    }

    @Override
    public String getPrivilegeId() {
        return this._privilegeId;
    }

    @Override
    public synchronized VmodlField[] getParameters() {
        return this._parameters;
    }

    @Override
    public VmodlField getResult() {
        return this._returnField;
    }

    @Override
    public VmodlType[] getFaults() {
        return this._faults;
    }

    @Override
    public VmodlType getFault(String wsdlName2) {
        return this._faultMap.get(wsdlName2);
    }

    @Override
    public boolean isInternal() {
        return this._internal;
    }

    @Override
    public VmodlVersion getVersion() {
        return this._version;
    }

    @Override
    public boolean isVisible(VmodlVersion version) {
        return version.isCompatible(this._version);
    }

    @Override
    public Method getMethod() {
        return this._method;
    }

    @Override
    public boolean isTask() {
        return this._isTask;
    }

    public void setManagedProperty(ManagedProperty managedProperty) {
        this._managedProperty = managedProperty;
    }

    @Override
    public ManagedProperty getManagedProperty() {
        return this._managedProperty;
    }

    private class MethodReturnField
    implements VmodlField {
        private boolean _optional;
        private boolean _secret;
        private VmodlField.CollectionType _collectionType;
        private String _managedObjectClassName;
        private VmodlType _managedObjectType;
        private static final String _returnFieldName = "returnval";
        private final VmodlContext _context;

        public MethodReturnField(boolean optional2, boolean secret2, VmodlField.CollectionType collectionType, String managedObjectClassName, VmodlContext context) {
            this._context = context;
            this._optional = optional2;
            this._secret = secret2;
            this._collectionType = collectionType;
            this._managedObjectClassName = managedObjectClassName;
        }

        @Override
        public String getName() {
            return _returnFieldName;
        }

        @Override
        public String getWsdlName() {
            return _returnFieldName;
        }

        @Override
        public VmodlType getType() {
            return ManagedMethodImpl.this._result;
        }

        @Override
        public VmodlVersion getVersion() {
            return ManagedMethodImpl.this._version;
        }

        @Override
        public String GetPrivilegeId() {
            return ManagedMethodImpl.this._privilegeId;
        }

        @Override
        public boolean isOptional() {
            return this._optional;
        }

        @Override
        public VmodlType getManagedObjectType() {
            if (this._managedObjectType == null) {
                Class<?> clazz = null;
                try {
                    clazz = ((VmodlContextImpl)this._context).loadClass(this._managedObjectClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error resolving class " + this._managedObjectClassName);
                }
                this._managedObjectType = this._context.getVmodlTypeMap().getVmodlType(clazz);
            }
            return this._managedObjectType;
        }

        @Override
        public boolean isLink() {
            return false;
        }

        @Override
        public boolean isLinkable() {
            return false;
        }

        @Override
        public boolean isVisible(VmodlVersion version) {
            return version.isCompatible(ManagedMethodImpl.this._version);
        }

        @Override
        public VmodlType getLinkType() {
            return null;
        }

        @Override
        public boolean isSecret() {
            return this._secret;
        }

        @Override
        public VmodlField.CollectionType getCollectionType() {
            return this._collectionType;
        }
    }
}

