/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.cis.authn.json;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.dsig.json.SignatureException;
import com.vmware.vapi.internal.security.SecurityUtil;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import java.security.cert.X509Certificate;
import java.util.Map;

public final class JsonSignatureStruct {
    public static final String SHA256_WITH_RSA = "RS256";
    private static final Message VERIFY_ERROR = MessageFactory.getMessage((String)"vapi.signature.verify", (String[])new String[0]);
    private static final DefaultTokenFactory TOKEN_FACTORY = new DefaultTokenFactory();
    private final String sigValue;
    private final SamlToken samlToken;
    private final String alg;

    public JsonSignatureStruct(String sigValue, SamlToken samlToken, String alg) {
        Validate.notNull((Object)sigValue);
        Validate.notNull((Object)samlToken);
        Validate.notNull((Object)alg);
        this.sigValue = sigValue;
        this.samlToken = samlToken;
        this.alg = alg;
    }

    public String getSigValue() {
        return this.sigValue;
    }

    public SamlToken getSamlToken() {
        return this.samlToken;
    }

    public String getAlg() {
        return this.alg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonSignatureStruct parseJsonSignatureStruct(Map<String, Object> jsonSignatureStruct, X509Certificate[] trustedRoots, long clockToleranceSec) {
        Validate.notNull(jsonSignatureStruct);
        Validate.notEmpty((Object[])trustedRoots);
        Validate.isTrue((clockToleranceSec > -1L ? 1 : 0) != 0);
        String sigValue = (String)SecurityUtil.narrowType((Object)jsonSignatureStruct.get("value"), String.class);
        String samlToken = (String)SecurityUtil.narrowType((Object)jsonSignatureStruct.get("samlToken"), String.class);
        String signingAlgorithm = (String)SecurityUtil.narrowType((Object)jsonSignatureStruct.get("signatureAlgorithm"), String.class);
        if (sigValue != null && samlToken != null && signingAlgorithm != null) {
            SamlToken parsedToken;
            try {
                DefaultTokenFactory defaultTokenFactory = TOKEN_FACTORY;
                synchronized (defaultTokenFactory) {
                    parsedToken = TOKEN_FACTORY.parseToken(samlToken, trustedRoots, clockToleranceSec);
                }
            }
            catch (InvalidTokenException e) {
                throw new SignatureException(VERIFY_ERROR, (Throwable)e);
            }
            return new JsonSignatureStruct(sigValue, parsedToken, signingAlgorithm);
        }
        throw new SignatureException(VERIFY_ERROR);
    }
}

