/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.utilities;

import com.vmware.srm.client.utilities.AsyncCollection;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;

public class ExecuteAll {
    private static final int MAX_THREADS = 5;
    private final Executor _exec;

    public ExecuteAll(Executor exec) {
        Validate.notNull((Object)exec, (String)"exec");
        this._exec = exec;
    }

    @SafeVarargs
    public final <T extends Callable<?>> AsyncCollection<Result<?>> submit(T ... tasks) {
        Validate.notEmpty((Object[])tasks, (String)"tasks");
        AsyncCollection results = new AsyncCollection();
        TaskHolder holder = new TaskHolder((Callable<?>[])tasks);
        int bound = Math.min(5, tasks.length);
        AtomicInteger runningTasks = new AtomicInteger(bound);
        for (int i = 0; i < bound; ++i) {
            this._exec.execute(new Worker(results, holder, runningTasks));
        }
        return results;
    }

    public AsyncCollection<Result<?>> submit(Collection<? extends Callable<?>> tasks) {
        Validate.notEmpty(tasks, (String)"tasks");
        Callable[] copy = new Callable[tasks.size()];
        tasks.toArray(copy);
        return this.submit(copy);
    }

    private static class Worker
    implements Runnable {
        private final AsyncCollection<Result<?>> _results;
        private final TaskHolder _tasks;
        private final AtomicInteger _runningTasks;

        Worker(AsyncCollection<Result<?>> results, TaskHolder tasks, AtomicInteger runningTasks) {
            this._results = results;
            this._tasks = tasks;
            this._runningTasks = runningTasks;
        }

        @Override
        public void run() {
            Callable<?> next = null;
            while ((next = this._tasks.nextTask()) != null) {
                Result result = null;
                try {
                    result = new Result(next, next.call());
                }
                catch (Exception e) {
                    result = new Result(next, e);
                }
                this._results.add(result);
            }
            if (this._runningTasks.decrementAndGet() == 0) {
                this._results.close();
            }
        }
    }

    private static class TaskHolder {
        private final Callable<?>[] _tasks;
        private final AtomicInteger _index = new AtomicInteger(0);

        TaskHolder(Callable<?>[] tasks) {
            Validate.notEmpty((Object[])tasks, (String)"tasks");
            this._tasks = tasks;
        }

        Callable<?> nextTask() {
            int index = this._index.getAndIncrement();
            if (index < this._tasks.length) {
                return this._tasks[index];
            }
            return null;
        }
    }

    public static class Result<V> {
        public final Callable<V> task;
        public final V result;
        public final Throwable error;

        private Result(Callable<V> task, V result, Throwable error) {
            this.task = task;
            this.result = result;
            this.error = error;
        }

        Result(Callable<V> task, V result) {
            this(task, result, null);
        }

        Result(Callable<V> task, Throwable error) {
            this(task, null, error);
        }

        public boolean completedWithError() {
            return this.error != null;
        }
    }
}

