/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.utilities;

import com.vmware.srm.client.utilities.OperationWaiter;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExecuteOnceOpWrapper<T> {
    private final Callable<T> _op;
    private final AtomicBoolean _opExecuted = new AtomicBoolean(false);
    private final OperationWaiter<T> _opWaiter = new OperationWaiter();

    public ExecuteOnceOpWrapper(Callable<T> op) {
        if (op == null) {
            throw new IllegalArgumentException("op");
        }
        this._op = op;
    }

    public OperationWaiter<T> invoke() {
        if (this._opExecuted.compareAndSet(false, true)) {
            try {
                this._opWaiter.setResult(this._op.call());
            }
            catch (Exception e) {
                this._opWaiter.setError(e);
            }
        }
        return this._opWaiter;
    }
}

