#This script intends to provide the host machine's hostname to the SRA container created by SRM. Container's entrypoint script will use the file created by this script to access the hostname for SSL certificate generation to conduct a secure SE client/server communication.
#This script will create an output file as 'hostname' in the directory '/tmp/vmware-srm/' on the host machine where SRM is installed. SRM mounts this path at the time of container creation.
#This script will need to be re-run post every system reboot.

#!/bin/bash

echo "Hostname of this machine is" $(hostname)
hostname_dir=/tmp/vmware-srm/
echo $(hostname) > $hostname_dir/hostname
if [[ $? == 0 ]]
then
    echo "SUCCESS: hostname file successfully created in the directory /tmp/vmware-srm/"
else
    echo "ERROR: /tmp/vmware-srm/ directory does not exist! Please run as a root user once SRM services are running!"
fi

#For VMware specific cert suite
hostname_dir=/tmp/vmware-root/
echo $(hostname) > $hostname_dir/hostname
if [[ $? == 0 ]]
then
    echo "SUCCESS: hostname file successfully created in the directory /tmp/vmware-root/"
else
    echo "ERROR: /tmp/vmware-root/ directory does not exist! Please run as a root user!"
fi

echo "exit"

