/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common;

public class RequestConfiguration {
    private final Integer timeout;
    private final Integer connectTimeout;

    private RequestConfiguration(Integer timeout, Integer connectTimeout) {
        this.timeout = timeout;
        this.connectTimeout = connectTimeout;
    }

    public Integer getTimeoutMs() {
        return this.timeout;
    }

    public Integer getConnectTimeoutMs() {
        return this.connectTimeout;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static class Builder {
        private Integer timeout;
        private Integer connectTimeout;

        public Builder setTimeoutMs(Integer timeout) {
            this.assertNonNegative(timeout);
            this.timeout = timeout;
            return this;
        }

        public Builder setConnectTimeoutMs(Integer connectTimeout) {
            this.assertNonNegative(connectTimeout);
            this.connectTimeout = connectTimeout;
            return this;
        }

        private void assertNonNegative(Integer value) {
            if (value != null && value < 0) {
                throw new IllegalArgumentException("Non-negative value or null expected");
            }
        }

        public RequestConfiguration build() {
            return new RequestConfiguration(this.timeout, this.connectTimeout);
        }
    }
}

