/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.ext;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InvocationContext {
    private final RequestContext _stubRequestContext;
    private final ManagedMethod _method;
    private final ManagedObjectReference _moRef;
    private final ProtocolBinding _binding;
    private final Map<String, Object> _options = new ConcurrentHashMap<String, Object>();
    private final Object[] _args;
    private InetSocketAddress _localAddress;
    private InetSocketAddress _remoteAddress;

    public InvocationContext(ManagedMethod method, ManagedObjectReference moRef, ProtocolBinding binding, Object[] args) {
        this(null, method, moRef, binding, args);
    }

    public InvocationContext(RequestContext stubRequestContext, ManagedMethod method, ManagedObjectReference moRef, ProtocolBinding binding, Object[] args) {
        this._stubRequestContext = stubRequestContext;
        this._method = method;
        this._moRef = moRef;
        this._binding = binding;
        this._args = args;
    }

    public ManagedMethod getMethod() {
        return this._method;
    }

    public ManagedObjectReference getMoRef() {
        return this._moRef;
    }

    public ProtocolBinding getBinding() {
        return this._binding;
    }

    public Object getInvocationContextObject(String key) {
        return this._options.get(key);
    }

    public void putInvocationContextObject(String key, Object obj) {
        this._options.put(key, obj);
    }

    public Object[] getArgs() {
        return this._args;
    }

    public RequestContext getStubRequestContext() {
        return this._stubRequestContext;
    }

    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public void setInetAddresses(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        this._localAddress = localAddress;
        this._remoteAddress = remoteAddress;
    }
}

