/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VecsUtils {
    public static final String TRUSTED_ROOT_CRLS = "TRUSTED_ROOT_CRLS";
    public static final String TRUSTED_ROOTS = "TRUSTED_ROOTS";
    private static final Log LOG = LogFactory.getLog(VecsUtils.class);
    private static final String USE_VECS_CERTSTORE_PROPERTY = "vlsi.client.vecs.certstore";
    private static final String VECS_CERTSTORE_PARAM_CLASS = "com.vmware.provider.VecsCertStoreParameters";
    private static final String CERTSTORE_TYPE = "VCS";
    private static final String USE_VECS_TRUSTSTORE_PROPERTY = "vlsi.client.vecs.truststore";
    private static final String VECS_KEYSTORE_PARAM_CLASS = "com.vmware.provider.VecsLoadStoreParameter";
    private static final String KEYSTORE_TYPE = "VKS";

    public static CertStore getVecsCertStore() {
        if (!Boolean.getBoolean(USE_VECS_CERTSTORE_PROPERTY)) {
            LOG.debug((Object)"vlsi.client.vecs.certstore is not set to true");
            return null;
        }
        CertStoreParameters vecsCSP = null;
        try {
            Class<?> clazz = Class.forName(VECS_CERTSTORE_PARAM_CLASS);
            Constructor<?> ctor = clazz.getConstructor(String.class);
            vecsCSP = (CertStoreParameters)ctor.newInstance(TRUSTED_ROOT_CRLS);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (SecurityException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object", (Throwable)e);
        }
        catch (ClassCastException e) {
            LOG.error((Object)"Failed to instantiate VecsLoadStoreParameter object", (Throwable)e);
        }
        if (vecsCSP != null) {
            try {
                return CertStore.getInstance(CERTSTORE_TYPE, vecsCSP);
            }
            catch (GeneralSecurityException e) {
                LOG.error((Object)"Failed to get VECS cert store", (Throwable)e);
            }
        }
        return null;
    }

    public static KeyStore getVecsTrustStore() {
        if (!Boolean.getBoolean(USE_VECS_TRUSTSTORE_PROPERTY)) {
            LOG.debug((Object)"vlsi.client.vecs.truststore is not set to true");
            return null;
        }
        KeyStore.LoadStoreParameter vecsLSP = null;
        try {
            Class<?> clazz = Class.forName(VECS_KEYSTORE_PARAM_CLASS);
            Constructor<?> ctor = clazz.getConstructor(String.class);
            vecsLSP = (KeyStore.LoadStoreParameter)ctor.newInstance(TRUSTED_ROOTS);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)"Failed to instantiate VecsCertStoreParameters object, seems like VECS classes are not available", (Throwable)e);
        }
        catch (SecurityException e) {
            LOG.error((Object)"Failed to instantiate VecsLoadStoreParameter object", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Failed to instantiate VecsLoadStoreParameter object", (Throwable)e);
        }
        catch (ClassCastException e) {
            LOG.error((Object)"Failed to instantiate VecsLoadStoreParameter object", (Throwable)e);
        }
        if (vecsLSP != null) {
            try {
                KeyStore trustStore = KeyStore.getInstance(KEYSTORE_TYPE);
                trustStore.load(vecsLSP);
                return trustStore;
            }
            catch (GeneralSecurityException e) {
                LOG.error((Object)"Failed to get VECS trust store", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to get VECS trust store", (Throwable)e);
            }
        }
        return null;
    }
}

