/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.processors.request;

import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.processors.request.RequestBuilderImpl;
import com.vmware.vim.sso.client.util.codec.Base64;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenResponseType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityHeaderType;

public final class ContinueAcquireTokenByGssRequestBuilder
extends RequestBuilderImpl {
    private static final String CHALLENGE_SOAP_ACTION = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Issue";
    private final String _contextId;
    private final byte[] _leg;

    public ContinueAcquireTokenByGssRequestBuilder(String contextId, byte[] leg, JAXBContext jaxbContext, int requestValidityInSeconds) {
        super(jaxbContext, requestValidityInSeconds, CHALLENGE_SOAP_ACTION);
        assert (leg != null);
        assert (contextId != null);
        this._contextId = contextId;
        this._leg = leg;
    }

    @Override
    protected void addSecurityHeaderInfo(SecurityHeaderType header) {
    }

    @Override
    protected JAXBElement<?> createBody(ObjectFactory wstFactory) throws ParserException {
        RequestSecurityTokenResponseType request = wstFactory.createRequestSecurityTokenResponseType();
        request.setContext(this._contextId);
        request.setBinaryExchange(this.createBinaryExchangeElement(wstFactory, this._leg));
        return new ObjectFactory().createRequestSecurityTokenResponse(request);
    }

    @Override
    protected void postProcessRequest(SoapMessage message) throws ParserException {
    }

    @Override
    protected String createRedactedDescription() {
        return this.getClass().getSimpleName() + " [contextId=" + this._contextId + ", leg=" + Base64.encodeBase64String(this._leg) + "]";
    }
}

