/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.decoding.impl;

import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.binding.impl.SAMLSOAPDecoderBodyHandler;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientResponseSOAP11Decoder
extends org.opensaml.soap.client.soap11.decoder.http.impl.HttpClientResponseSOAP11Decoder<SAMLObject>
implements SAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HttpClientResponseSOAP11Decoder.class);

    public HttpClientResponseSOAP11Decoder() {
        this.setBodyHandler((MessageHandler)new SAMLSOAPDecoderBodyHandler());
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding";
    }

    protected void doDecode() throws MessageDecodingException {
        super.doDecode();
        this.populateBindingContext((MessageContext<SAMLObject>)this.getMessageContext());
        SAMLObject samlMessage = (SAMLObject)this.getMessageContext().getMessage();
        this.log.debug("Decoded SOAP messaged which included SAML message of type {}", (Object)samlMessage.getElementQName());
    }

    protected void populateBindingContext(MessageContext<SAMLObject> messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }
}

