/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.util;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vcenter.certificate_management.StructDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.TlsCsrDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.TlsDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.TrustedRootChainsDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.VmcaRootDefinitions;
import com.vmware.vcenter.identity.ForeignSecurityPrincipalsDefinitions;
import com.vmware.vcenter.identity.ProvidersDefinitions;
import com.vmware.vcenter.identity.VcIdentityDefinitions;
import com.vmware.vcenter.trust.VcTrustsDefinitions;
import java.util.Map;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.x509_cert_chain", StructDefinitions.x509CertChain);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.trusted_root_chains.info", TrustedRootChainsDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.trusted_root_chains.summary", TrustedRootChainsDefinitions.summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.trusted_root_chains.create_spec", TrustedRootChainsDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls.info", TlsDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls.spec", TlsDefinitions.spec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls.replace_spec", TlsDefinitions.replaceSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls_csr.info", TlsCsrDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls_csr.spec", TlsCsrDefinitions.spec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.vmca_root.create_spec", VmcaRootDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.foreign_security_principals.info", ForeignSecurityPrincipalsDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.foreign_security_principals.create_spec", ForeignSecurityPrincipalsDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.foreign_security_principals.update_spec", ForeignSecurityPrincipalsDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.summary", ProvidersDefinitions.summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.info", ProvidersDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.create_spec", ProvidersDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.update_spec", ProvidersDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_summary", ProvidersDefinitions.oauth2Summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_info", ProvidersDefinitions.oauth2Info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_create_spec", ProvidersDefinitions.oauth2CreateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_update_spec", ProvidersDefinitions.oauth2UpdateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oidc_summary", ProvidersDefinitions.oidcSummary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oidc_info", ProvidersDefinitions.oidcInfo);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oidc_create_spec", ProvidersDefinitions.oidcCreateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oidc_update_spec", ProvidersDefinitions.oidcUpdateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.active_directory_over_ldap", ProvidersDefinitions.activeDirectoryOverLdap);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.vc_identity.update_spec", VcIdentityDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.vc_identity.info", VcIdentityDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.trust.vc_trusts.create_spec", VcTrustsDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.trust.vc_trusts.update_spec", VcTrustsDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.trust.vc_trusts.info", VcTrustsDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.trust.vc_trusts.summary", VcTrustsDefinitions.summary);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key + ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}

