/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.ImportSpec;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.ResourceConfigOption;
import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.vApp.VAppConfigSpec;
import com.vmware.vim.binding.vim.version.v7_0;
import com.vmware.vim.binding.vim.version.version1;
import com.vmware.vim.binding.vim.version.version5;
import com.vmware.vim.binding.vim.version.version6;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.silent;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@fullyQualifiedVmodlName(value="vim.ResourcePool")
@managed
@versionClass(value=version1.class)
@wsdlName(value="ResourcePool")
public interface ResourcePool
extends ManagedEntity {
    @readonly
    @name(value="summary")
    @versionClass(value=version1.class)
    public void getSummary(Future<Summary> var1);

    @readonly
    @name(value="runtime")
    @versionClass(value=version1.class)
    public void getRuntime(Future<RuntimeInfo> var1);

    @readonly
    @name(value="owner")
    @privilege(value="System.View")
    @versionClass(value=version1.class)
    @managedObjectType(value="com.vmware.vim.binding.vim.ComputeResource")
    public void getOwner(@managedObjectType(value="com.vmware.vim.binding.vim.ComputeResource") Future<ManagedObjectReference> var1);

    @readonly
    @name(value="resourcePool")
    @privilege(value="System.View")
    @versionClass(value=version1.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.vim.ResourcePool")
    @map
    public void getResourcePool(@optional @managedObjectType(value="com.vmware.vim.binding.vim.ResourcePool") Future<ManagedObjectReference[]> var1);

    @readonly
    @name(value="vm")
    @privilege(value="System.View")
    @versionClass(value=version1.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.vim.VirtualMachine")
    @map
    public void getVm(@optional @managedObjectType(value="com.vmware.vim.binding.vim.VirtualMachine") Future<ManagedObjectReference[]> var1);

    @readonly
    @name(value="config")
    @versionClass(value=version1.class)
    public void getConfig(Future<ResourceConfigSpec> var1);

    @readonly
    @name(value="namespace")
    @privilege(value="System.View")
    @versionClass(value=v7_0.class)
    @optional
    public void getNamespace(@optional Future<String> var1);

    @readonly
    @name(value="childConfiguration")
    @versionClass(value=version1.class)
    @optional
    @list
    public void getChildConfiguration(@optional Future<ResourceConfigSpec[]> var1);

    @versionClass(value=version5.class)
    @wsdlName(value="CreateChildVM_Task")
    @privilege(value="VirtualMachine.Inventory.Create")
    @task
    @faults(value={"VmConfigFault", "FileFault", "OutOfBounds", "InvalidName", "InvalidDatastore", "InsufficientResourcesFault"})
    public void createVm(@name(value="config") @versionClass(value=version5.class) ConfigSpec var1, @name(value="host") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var2, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @versionClass(value=v7_0.class)
    @wsdlName(value="CreateNamespaceResourcePool")
    @privilege(value="dynamic")
    @internal
    @faults(value={"InvalidName", "DuplicateName", "InsufficientResourcesFault"})
    public void createNamespaceResourcePool(@name(value="name") @versionClass(value=v7_0.class) String var1, @name(value="spec") @versionClass(value=v7_0.class) ResourceConfigSpec var2, @name(value="namespaceId") @versionClass(value=v7_0.class) String var3, @managedObjectType(value="com.vmware.vim.binding.vim.ResourcePool") Future<ManagedObjectReference> var4);

    @versionClass(value=version1.class)
    @wsdlName(value="CreateResourcePool")
    @privilege(value="Resource.CreatePool")
    @faults(value={"InvalidName", "DuplicateName", "InsufficientResourcesFault"})
    public void createResourcePool(@name(value="name") @versionClass(value=version1.class) String var1, @name(value="spec") @versionClass(value=version1.class) ResourceConfigSpec var2, @managedObjectType(value="com.vmware.vim.binding.vim.ResourcePool") Future<ManagedObjectReference> var3);

    @versionClass(value=version5.class)
    @wsdlName(value="CreateVApp")
    @privilege(value="VApp.Create")
    @faults(value={"InvalidName", "DuplicateName", "InsufficientResourcesFault", "InvalidState", "VmConfigFault"})
    public void createVApp(@name(value="name") @versionClass(value=version5.class) String var1, @name(value="resSpec") @versionClass(value=version5.class) ResourceConfigSpec var2, @name(value="configSpec") @versionClass(value=version5.class) VAppConfigSpec var3, @name(value="vmFolder") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.Folder") ManagedObjectReference var4, @managedObjectType(value="com.vmware.vim.binding.vim.VirtualApp") Future<ManagedObjectReference> var5);

    @versionClass(value=version1.class)
    @wsdlName(value="DestroyChildren")
    @privilege(value="dynamic")
    public void destroyChildren(Future<Void> var1);

    @versionClass(value=version5.class)
    @wsdlName(value="ImportVApp")
    @privilege(value="VApp.Import")
    @faults(value={"VmConfigFault", "FileFault", "OutOfBounds", "DuplicateName", "InvalidName", "InvalidDatastore", "InsufficientResourcesFault"})
    public void importVApp(@name(value="spec") @versionClass(value=version5.class) ImportSpec var1, @name(value="folder") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.Folder") @privilege(value="VApp.Import") ManagedObjectReference var2, @name(value="host") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var3, @managedObjectType(value="com.vmware.vim.binding.vim.HttpNfcLease") Future<ManagedObjectReference> var4);

    @versionClass(value=version1.class)
    @wsdlName(value="MoveIntoResourcePool")
    @privilege(value="dynamic")
    @faults(value={"DuplicateName", "InsufficientResourcesFault"})
    public void moveInto(@name(value="list") @versionClass(value=version1.class) @managedObjectType(value="com.vmware.vim.binding.vim.ManagedEntity") @map ManagedObjectReference[] var1, Future<Void> var2);

    @versionClass(value=version6.class)
    @wsdlName(value="QueryResourceConfigOption")
    @privilege(value="Resource.EditPool")
    @Deprecated
    public void queryResourceConfigOption(Future<ResourceConfigOption> var1);

    @versionClass(value=version6.class)
    @wsdlName(value="RefreshRuntime")
    @privilege(value="System.View")
    public void refreshRuntime(Future<Void> var1);

    @versionClass(value=version5.class)
    @wsdlName(value="RegisterChildVM_Task")
    @privilege(value="VirtualMachine.Inventory.Register")
    @task
    @faults(value={"OutOfBounds", "AlreadyExists", "InvalidDatastore", "NotFound", "InvalidName", "VmConfigFault", "InsufficientResourcesFault", "FileFault"})
    public void registerVm(@name(value="path") @versionClass(value=version5.class) String var1, @name(value="name") @versionClass(value=version5.class) @optional String var2, @name(value="host") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var3, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var4);

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateChildResourceConfiguration")
    @privilege(value="dynamic")
    @faults(value={"InvalidState", "InsufficientResourcesFault"})
    public void updateChildResourceConfiguration(@name(value="spec") @versionClass(value=version1.class) @list ResourceConfigSpec[] var1, Future<Void> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateConfig")
    @privilege(value="dynamic")
    @faults(value={"InvalidName", "DuplicateName", "InsufficientResourcesFault", "ConcurrentAccess"})
    public void updateConfig(@name(value="name") @versionClass(value=version1.class) @optional String var1, @name(value="config") @versionClass(value=version1.class) @optional ResourceConfigSpec var2, Future<Void> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="ResourcePoolSummary")
    @data
    @propertyOrder(value={"name", "config", "runtime", "quickStats", "configuredMemoryMB"})
    public static class Summary
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String name;
        public ResourceConfigSpec config;
        public RuntimeInfo runtime;
        public QuickStats quickStats;
        public Integer configuredMemoryMB;

        public Summary() {
        }

        public Summary(String name2, ResourceConfigSpec config, RuntimeInfo runtime, QuickStats quickStats, Integer configuredMemoryMB) {
            this.name = name2;
            this.config = config;
            this.runtime = runtime;
            this.quickStats = quickStats;
            this.configuredMemoryMB = configuredMemoryMB;
        }

        @versionClass(value=version1.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version1.class)
        public void setName(String name2) {
            this.name = name2;
        }

        @versionClass(value=version1.class)
        public ResourceConfigSpec getConfig() {
            return this.config;
        }

        @versionClass(value=version1.class)
        public void setConfig(ResourceConfigSpec config) {
            this.config = config;
        }

        @versionClass(value=version1.class)
        public RuntimeInfo getRuntime() {
            return this.runtime;
        }

        @versionClass(value=version1.class)
        public void setRuntime(RuntimeInfo runtime) {
            this.runtime = runtime;
        }

        @optional
        @versionClass(value=version5.class)
        @silent
        public QuickStats getQuickStats() {
            return this.quickStats;
        }

        @optional
        @versionClass(value=version5.class)
        @silent
        public void setQuickStats(QuickStats quickStats) {
            this.quickStats = quickStats;
        }

        @optional
        @versionClass(value=version5.class)
        @silent
        public Integer getConfiguredMemoryMB() {
            return this.configuredMemoryMB;
        }

        @optional
        @versionClass(value=version5.class)
        @silent
        public void setConfiguredMemoryMB(Integer configuredMemoryMB) {
            this.configuredMemoryMB = configuredMemoryMB;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(280);
            objString.append("(vim.Summary) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("name = ");
            objString.append(this.getName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("config = ");
            if (this.getConfig() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getConfig()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("runtime = ");
            if (this.getRuntime() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getRuntime()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("quickStats = ");
            if (this.getQuickStats() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getQuickStats()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("configuredMemoryMB = ");
            objString.append(this.getConfiguredMemoryMB());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version5.class)
        @wsdlName(value="ResourcePoolQuickStats")
        @data
        @propertyOrder(value={"overallCpuUsage", "overallCpuDemand", "guestMemoryUsage", "hostMemoryUsage", "distributedCpuEntitlement", "distributedMemoryEntitlement", "staticCpuEntitlement", "staticMemoryEntitlement", "privateMemory", "sharedMemory", "swappedMemory", "balloonedMemory", "overheadMemory", "consumedOverheadMemory", "compressedMemory"})
        public static class QuickStats
        extends DynamicDataImpl {
            private static final long serialVersionUID = 1L;
            public Long overallCpuUsage;
            public Long overallCpuDemand;
            public Long guestMemoryUsage;
            public Long hostMemoryUsage;
            public Long distributedCpuEntitlement;
            public Long distributedMemoryEntitlement;
            public Integer staticCpuEntitlement;
            public Integer staticMemoryEntitlement;
            public Long privateMemory;
            public Long sharedMemory;
            public Long swappedMemory;
            public Long balloonedMemory;
            public Long overheadMemory;
            public Long consumedOverheadMemory;
            public Long compressedMemory;

            public QuickStats() {
            }

            public QuickStats(Long overallCpuUsage, Long overallCpuDemand, Long guestMemoryUsage, Long hostMemoryUsage, Long distributedCpuEntitlement, Long distributedMemoryEntitlement, Integer staticCpuEntitlement, Integer staticMemoryEntitlement, Long privateMemory, Long sharedMemory, Long swappedMemory, Long balloonedMemory, Long overheadMemory, Long consumedOverheadMemory, Long compressedMemory) {
                this.overallCpuUsage = overallCpuUsage;
                this.overallCpuDemand = overallCpuDemand;
                this.guestMemoryUsage = guestMemoryUsage;
                this.hostMemoryUsage = hostMemoryUsage;
                this.distributedCpuEntitlement = distributedCpuEntitlement;
                this.distributedMemoryEntitlement = distributedMemoryEntitlement;
                this.staticCpuEntitlement = staticCpuEntitlement;
                this.staticMemoryEntitlement = staticMemoryEntitlement;
                this.privateMemory = privateMemory;
                this.sharedMemory = sharedMemory;
                this.swappedMemory = swappedMemory;
                this.balloonedMemory = balloonedMemory;
                this.overheadMemory = overheadMemory;
                this.consumedOverheadMemory = consumedOverheadMemory;
                this.compressedMemory = compressedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getOverallCpuUsage() {
                return this.overallCpuUsage;
            }

            @optional
            @versionClass(value=version5.class)
            public void setOverallCpuUsage(Long overallCpuUsage) {
                this.overallCpuUsage = overallCpuUsage;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getOverallCpuDemand() {
                return this.overallCpuDemand;
            }

            @optional
            @versionClass(value=version5.class)
            public void setOverallCpuDemand(Long overallCpuDemand) {
                this.overallCpuDemand = overallCpuDemand;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getGuestMemoryUsage() {
                return this.guestMemoryUsage;
            }

            @optional
            @versionClass(value=version5.class)
            public void setGuestMemoryUsage(Long guestMemoryUsage) {
                this.guestMemoryUsage = guestMemoryUsage;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getHostMemoryUsage() {
                return this.hostMemoryUsage;
            }

            @optional
            @versionClass(value=version5.class)
            public void setHostMemoryUsage(Long hostMemoryUsage) {
                this.hostMemoryUsage = hostMemoryUsage;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getDistributedCpuEntitlement() {
                return this.distributedCpuEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public void setDistributedCpuEntitlement(Long distributedCpuEntitlement) {
                this.distributedCpuEntitlement = distributedCpuEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getDistributedMemoryEntitlement() {
                return this.distributedMemoryEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public void setDistributedMemoryEntitlement(Long distributedMemoryEntitlement) {
                this.distributedMemoryEntitlement = distributedMemoryEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public Integer getStaticCpuEntitlement() {
                return this.staticCpuEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public void setStaticCpuEntitlement(Integer staticCpuEntitlement) {
                this.staticCpuEntitlement = staticCpuEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public Integer getStaticMemoryEntitlement() {
                return this.staticMemoryEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public void setStaticMemoryEntitlement(Integer staticMemoryEntitlement) {
                this.staticMemoryEntitlement = staticMemoryEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getPrivateMemory() {
                return this.privateMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setPrivateMemory(Long privateMemory) {
                this.privateMemory = privateMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getSharedMemory() {
                return this.sharedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setSharedMemory(Long sharedMemory) {
                this.sharedMemory = sharedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getSwappedMemory() {
                return this.swappedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setSwappedMemory(Long swappedMemory) {
                this.swappedMemory = swappedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getBalloonedMemory() {
                return this.balloonedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setBalloonedMemory(Long balloonedMemory) {
                this.balloonedMemory = balloonedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getOverheadMemory() {
                return this.overheadMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setOverheadMemory(Long overheadMemory) {
                this.overheadMemory = overheadMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getConsumedOverheadMemory() {
                return this.consumedOverheadMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setConsumedOverheadMemory(Long consumedOverheadMemory) {
                this.consumedOverheadMemory = consumedOverheadMemory;
            }

            @optional
            @versionClass(value=version6.class)
            public Long getCompressedMemory() {
                return this.compressedMemory;
            }

            @optional
            @versionClass(value=version6.class)
            public void setCompressedMemory(Long compressedMemory) {
                this.compressedMemory = compressedMemory;
            }

            public String toString() {
                StringBuilder objString = new StringBuilder(680);
                objString.append("(vim.QuickStats) {\n");
                objString.append("   ");
                objString.append("dynamicType = ");
                objString.append(this.getDynamicType());
                objString.append(",\n");
                objString.append("   ");
                objString.append("dynamicProperty = ");
                if (this.getDynamicProperty() == null) {
                    objString.append("null");
                } else {
                    objString.append("(vmodl.DynamicProperty) [\n");
                    for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                        objString.append("      ");
                        objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                        if (i < this.getDynamicProperty().length - 1) {
                            objString.append(",");
                        }
                        objString.append("\n");
                    }
                    objString.append("   ");
                    objString.append("]");
                }
                objString.append(",\n");
                objString.append("   ");
                objString.append("overallCpuUsage = ");
                objString.append(this.getOverallCpuUsage());
                objString.append(",\n");
                objString.append("   ");
                objString.append("overallCpuDemand = ");
                objString.append(this.getOverallCpuDemand());
                objString.append(",\n");
                objString.append("   ");
                objString.append("guestMemoryUsage = ");
                objString.append(this.getGuestMemoryUsage());
                objString.append(",\n");
                objString.append("   ");
                objString.append("hostMemoryUsage = ");
                objString.append(this.getHostMemoryUsage());
                objString.append(",\n");
                objString.append("   ");
                objString.append("distributedCpuEntitlement = ");
                objString.append(this.getDistributedCpuEntitlement());
                objString.append(",\n");
                objString.append("   ");
                objString.append("distributedMemoryEntitlement = ");
                objString.append(this.getDistributedMemoryEntitlement());
                objString.append(",\n");
                objString.append("   ");
                objString.append("staticCpuEntitlement = ");
                objString.append(this.getStaticCpuEntitlement());
                objString.append(",\n");
                objString.append("   ");
                objString.append("staticMemoryEntitlement = ");
                objString.append(this.getStaticMemoryEntitlement());
                objString.append(",\n");
                objString.append("   ");
                objString.append("privateMemory = ");
                objString.append(this.getPrivateMemory());
                objString.append(",\n");
                objString.append("   ");
                objString.append("sharedMemory = ");
                objString.append(this.getSharedMemory());
                objString.append(",\n");
                objString.append("   ");
                objString.append("swappedMemory = ");
                objString.append(this.getSwappedMemory());
                objString.append(",\n");
                objString.append("   ");
                objString.append("balloonedMemory = ");
                objString.append(this.getBalloonedMemory());
                objString.append(",\n");
                objString.append("   ");
                objString.append("overheadMemory = ");
                objString.append(this.getOverheadMemory());
                objString.append(",\n");
                objString.append("   ");
                objString.append("consumedOverheadMemory = ");
                objString.append(this.getConsumedOverheadMemory());
                objString.append(",\n");
                objString.append("   ");
                objString.append("compressedMemory = ");
                objString.append(this.getCompressedMemory());
                objString.append("\n}");
                return objString.toString();
            }
        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="ResourcePoolRuntimeInfo")
    @data
    @propertyOrder(value={"memory", "cpu", "overallStatus", "sharesScalable"})
    public static class RuntimeInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public ResourceUsage memory;
        public ResourceUsage cpu;
        public ManagedEntity.Status overallStatus;
        public String sharesScalable;

        public RuntimeInfo() {
        }

        public RuntimeInfo(ResourceUsage memory, ResourceUsage cpu, ManagedEntity.Status overallStatus, String sharesScalable) {
            this.memory = memory;
            this.cpu = cpu;
            this.overallStatus = overallStatus;
            this.sharesScalable = sharesScalable;
        }

        @versionClass(value=version1.class)
        @silent
        public ResourceUsage getMemory() {
            return this.memory;
        }

        @versionClass(value=version1.class)
        @silent
        public void setMemory(ResourceUsage memory) {
            this.memory = memory;
        }

        @versionClass(value=version1.class)
        @silent
        public ResourceUsage getCpu() {
            return this.cpu;
        }

        @versionClass(value=version1.class)
        @silent
        public void setCpu(ResourceUsage cpu) {
            this.cpu = cpu;
        }

        @versionClass(value=version1.class)
        public ManagedEntity.Status getOverallStatus() {
            return this.overallStatus;
        }

        @versionClass(value=version1.class)
        public void setOverallStatus(ManagedEntity.Status overallStatus) {
            this.overallStatus = overallStatus;
        }

        @optional
        @versionClass(value=v7_0.class)
        public String getSharesScalable() {
            return this.sharesScalable;
        }

        @optional
        @versionClass(value=v7_0.class)
        public void setSharesScalable(String sharesScalable) {
            this.sharesScalable = sharesScalable;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(240);
            objString.append("(vim.RuntimeInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("memory = ");
            if (this.getMemory() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getMemory()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("cpu = ");
            if (this.getCpu() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getCpu()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("overallStatus = ");
            objString.append((Object)this.getOverallStatus());
            objString.append(",\n");
            objString.append("   ");
            objString.append("sharesScalable = ");
            objString.append(this.getSharesScalable());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="ResourcePoolResourceUsage")
    @data
    @propertyOrder(value={"reservationUsed", "reservationUsedForVm", "unreservedForPool", "unreservedForVm", "overallUsage", "maxUsage"})
    public static class ResourceUsage
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public long reservationUsed;
        public long reservationUsedForVm;
        public long unreservedForPool;
        public long unreservedForVm;
        public long overallUsage;
        public long maxUsage;

        public ResourceUsage() {
        }

        public ResourceUsage(long reservationUsed, long reservationUsedForVm, long unreservedForPool, long unreservedForVm, long overallUsage, long maxUsage) {
            this.reservationUsed = reservationUsed;
            this.reservationUsedForVm = reservationUsedForVm;
            this.unreservedForPool = unreservedForPool;
            this.unreservedForVm = unreservedForVm;
            this.overallUsage = overallUsage;
            this.maxUsage = maxUsage;
        }

        @versionClass(value=version1.class)
        public long getReservationUsed() {
            return this.reservationUsed;
        }

        @versionClass(value=version1.class)
        public void setReservationUsed(long reservationUsed) {
            this.reservationUsed = reservationUsed;
        }

        @versionClass(value=version1.class)
        public long getReservationUsedForVm() {
            return this.reservationUsedForVm;
        }

        @versionClass(value=version1.class)
        public void setReservationUsedForVm(long reservationUsedForVm) {
            this.reservationUsedForVm = reservationUsedForVm;
        }

        @versionClass(value=version1.class)
        public long getUnreservedForPool() {
            return this.unreservedForPool;
        }

        @versionClass(value=version1.class)
        public void setUnreservedForPool(long unreservedForPool) {
            this.unreservedForPool = unreservedForPool;
        }

        @versionClass(value=version1.class)
        public long getUnreservedForVm() {
            return this.unreservedForVm;
        }

        @versionClass(value=version1.class)
        public void setUnreservedForVm(long unreservedForVm) {
            this.unreservedForVm = unreservedForVm;
        }

        @versionClass(value=version1.class)
        public long getOverallUsage() {
            return this.overallUsage;
        }

        @versionClass(value=version1.class)
        public void setOverallUsage(long overallUsage) {
            this.overallUsage = overallUsage;
        }

        @versionClass(value=version1.class)
        public long getMaxUsage() {
            return this.maxUsage;
        }

        @versionClass(value=version1.class)
        public void setMaxUsage(long maxUsage) {
            this.maxUsage = maxUsage;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(320);
            objString.append("(vim.ResourceUsage) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("reservationUsed = ");
            objString.append(this.getReservationUsed());
            objString.append(",\n");
            objString.append("   ");
            objString.append("reservationUsedForVm = ");
            objString.append(this.getReservationUsedForVm());
            objString.append(",\n");
            objString.append("   ");
            objString.append("unreservedForPool = ");
            objString.append(this.getUnreservedForPool());
            objString.append(",\n");
            objString.append("   ");
            objString.append("unreservedForVm = ");
            objString.append(this.getUnreservedForVm());
            objString.append(",\n");
            objString.append("   ");
            objString.append("overallUsage = ");
            objString.append(this.getOverallUsage());
            objString.append(",\n");
            objString.append("   ");
            objString.append("maxUsage = ");
            objString.append(this.getMaxUsage());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

