/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim.host;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.version.version10;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@fullyQualifiedVmodlName(value="vim.host.HostAccessManager")
@managed
@versionClass(value=version10.class)
@wsdlName(value="HostAccessManager")
public interface HostAccessManager
extends ManagedObject {
    @readonly
    @name(value="lockdownMode")
    @privilege(value="System.View")
    @versionClass(value=version10.class)
    public void getLockdownMode(Future<LockdownMode> var1);

    @versionClass(value=version10.class)
    @wsdlName(value="ChangeAccessMode")
    @privilege(value="Global.Settings")
    @faults(value={"AuthMinimumAdminPermission", "UserNotFound"})
    public void changeAccessMode(@name(value="principal") @versionClass(value=version10.class) String var1, @name(value="isGroup") @versionClass(value=version10.class) boolean var2, @name(value="accessMode") @versionClass(value=version10.class) AccessMode var3, Future<Void> var4);

    @versionClass(value=version10.class)
    @wsdlName(value="ChangeLockdownMode")
    @privilege(value="Host.Config.Settings")
    @faults(value={"AuthMinimumAdminPermission"})
    public void changeLockdownMode(@name(value="mode") @versionClass(value=version10.class) LockdownMode var1, Future<Void> var2);

    @versionClass(value=version10.class)
    @wsdlName(value="QueryLockdownExceptions")
    @privilege(value="Global.Settings")
    @map
    public void queryLockdownExceptions(@optional @map Future<String[]> var1);

    @versionClass(value=version10.class)
    @wsdlName(value="QuerySystemUsers")
    @privilege(value="Global.Settings")
    @map
    public void querySystemUsers(@optional @map Future<String[]> var1);

    @versionClass(value=version10.class)
    @wsdlName(value="RetrieveHostAccessControlEntries")
    @privilege(value="Global.Settings")
    @list
    public void retrieveAccessEntries(@optional @list Future<AccessEntry[]> var1);

    @versionClass(value=version10.class)
    @wsdlName(value="UpdateLockdownExceptions")
    @privilege(value="Global.Settings")
    @faults(value={"AuthMinimumAdminPermission", "UserNotFound"})
    public void updateLockdownExceptions(@name(value="users") @versionClass(value=version10.class) @optional @map String[] var1, Future<Void> var2);

    @versionClass(value=version10.class)
    @wsdlName(value="UpdateSystemUsers")
    @privilege(value="Global.Settings")
    @faults(value={"UserNotFound"})
    public void updateSystemUsers(@name(value="users") @versionClass(value=version10.class) @optional @map String[] var1, Future<Void> var2);

    @versionClass(value=version10.class)
    @wsdlName(value="HostLockdownMode")
    public static enum LockdownMode {
        lockdownDisabled,
        lockdownNormal,
        lockdownStrict;

    }

    @versionClass(value=version10.class)
    @wsdlName(value="HostAccessMode")
    public static enum AccessMode {
        accessNone,
        accessAdmin,
        accessNoAccess,
        accessReadOnly,
        accessOther;

    }

    @versionClass(value=version10.class)
    @wsdlName(value="HostAccessControlEntry")
    @data
    @propertyOrder(value={"principal", "group", "accessMode"})
    public static class AccessEntry
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String principal;
        public boolean group;
        public AccessMode accessMode;

        public AccessEntry() {
        }

        public AccessEntry(String principal, boolean group, AccessMode accessMode) {
            this.principal = principal;
            this.group = group;
            this.accessMode = accessMode;
        }

        @versionClass(value=version10.class)
        public String getPrincipal() {
            return this.principal;
        }

        @versionClass(value=version10.class)
        public void setPrincipal(String principal) {
            this.principal = principal;
        }

        @versionClass(value=version10.class)
        public boolean isGroup() {
            return this.group;
        }

        @versionClass(value=version10.class)
        public void setGroup(boolean group) {
            this.group = group;
        }

        @versionClass(value=version10.class)
        public AccessMode getAccessMode() {
            return this.accessMode;
        }

        @versionClass(value=version10.class)
        public void setAccessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(vim.host.AccessEntry) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("principal = ");
            objString.append(this.getPrincipal());
            objString.append(",\n");
            objString.append("   ");
            objString.append("group = ");
            objString.append(this.isGroup());
            objString.append(",\n");
            objString.append("   ");
            objString.append("accessMode = ");
            objString.append((Object)this.getAccessMode());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

