/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.authentication.CsrfGuard;
import com.vmware.srm.client.infrastructure.authentication.SessionInfo;
import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthenticationFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.processRequest(httpRequest, httpResponse, chain);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!AuthenticationUtils.isAuthenticated(request)) {
            AuthenticationUtils.invalidateSession(request);
            response.sendError(401);
            return;
        }
        if (!CsrfGuard.enforce((ServletRequest)request, (ServletResponse)response)) {
            return;
        }
        Callable<Void> task = () -> {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return null;
        };
        HttpSession session = request.getSession(false);
        String username = SessionWrapper.getUsername(session);
        String sessionIdAlias = SessionWrapper.getSessionIdAlias(session);
        try {
            SessionInfo.withSessionInfo(task, username, sessionIdAlias).call();
        }
        catch (IOException | ServletException exc) {
            throw exc;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

