/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.data.RemoteSiteData;
import com.vmware.srm.client.infrastructure.authentication.data.ServerGuidData;
import com.vmware.srm.client.infrastructure.exceptions.ExceptionUtil;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import org.apache.commons.lang.Validate;

@DrInputType(value=ServerGuidData.class)
public class RemoteSiteDataHandler
implements FreeRequestHandler {
    @Override
    public Promise<RemoteSiteData> handle(DrData input, FreeRequestContext context) {
        ServerGuidData guidData = (ServerGuidData)input;
        String serverGuid = guidData.getServerGuid();
        String pairServerGuid = guidData.getPairServerGuid();
        Object view = context.view();
        return this.checkVcSite((ServersView)view, serverGuid, pairServerGuid);
    }

    private Promise<RemoteSiteData> checkVcSite(ServersView view, String serverGuid, String pairServerGuid) {
        return view.getServerBy(pairServerGuid).materialize().thenCompose(serverResult -> {
            if (serverResult.isSuccessful()) {
                return this.verifyServerAuthenticated((Server)serverResult.getResult()).thenApply(authenticated -> new RemoteSiteData(pairServerGuid, (boolean)authenticated, serverGuid));
            }
            Exception error = serverResult.getError();
            if (error instanceof ExtensionServersView.ServerByPairSetupException) {
                ExtensionServersView.ServerByPairSetupException sbpsExc = (ExtensionServersView.ServerByPairSetupException)error;
                Exception lastExc = null;
                for (PairSetup ps : sbpsExc.getPairSetups()) {
                    if (serverGuid.equals(ps.server().vc().guid())) {
                        lastExc = sbpsExc.getCause(ps);
                    }
                    if (!(lastExc instanceof NotAuthenticated)) continue;
                    return Promises.resolve((Object)new RemoteSiteData(pairServerGuid, false, serverGuid));
                }
                if (lastExc == null) {
                    return Promises.reject((Exception)new RuntimeException(L10N.localize("noEligiblePairSetup", pairServerGuid)));
                }
                return Promises.reject(lastExc);
            }
            return Promises.reject((Exception)serverResult.getError());
        });
    }

    private Promise<Boolean> verifyServerAuthenticated(Server<?> server) {
        Validate.notNull(server, (String)"server");
        return server.getStatus().thenApply(status -> {
            switch (status) {
                case ok: {
                    return true;
                }
                case not_authenticated: {
                    return false;
                }
                case no_connection: 
                case ssl_error: {
                    throw ExceptionUtil.getNoConnectionError(server.url());
                }
                case internal_error: {
                    throw ExceptionUtil.getRuntimeException("internalServerError");
                }
            }
            throw new IllegalArgumentException("Unknown 'status' value: " + status);
        });
    }
}

