/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.Credentials;
import com.vmware.srm.client.infrastructure.authentication.SAStoreManager;
import com.vmware.srm.client.infrastructure.vapi.AsyncCallbackPromise;
import com.vmware.srm.client.infrastructure.vapi.VapiServiceImpl;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.sso.TokenManager;
import com.vmware.vcenter.svcaccountmgmt.Password;
import com.vmware.vcenter.svcaccountmgmt.PasswordTypes;
import com.vmware.vim.sso.client.exception.AuthenticationFailedException;
import com.vmware.vim.sso.client.exception.PasswordExpiredException;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SACredentialsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SACredentialsManager.class);
    private final long EXP_TIME = TimeUnit.MINUTES.toSeconds(5L);
    private final SAStoreManager _storeManager;
    private final LsppService _ssoReg;
    private final LsppServiceEndpoint _vapiEp;
    private final AtomicReference<Promise<Credentials>> _currentRequest = new AtomicReference<Object>(null);

    public SACredentialsManager(Path saPath, LsppService ssoReg, LsppServiceEndpoint vapiEp) {
        this._storeManager = new SAStoreManager(saPath);
        this._ssoReg = ssoReg;
        this._vapiEp = vapiEp;
    }

    public Promise<Credentials> getCredentials() {
        PromiseImpl thisPromise = new PromiseImpl();
        thisPromise.materialize().onSuccess(unused -> this._currentRequest.set(null));
        while (!this._currentRequest.compareAndSet(null, (Promise<Credentials>)thisPromise)) {
            Promise<Credentials> current = this._currentRequest.get();
            if (current == null) continue;
            return current;
        }
        this.getCredentialsInternal((PromiseImpl<Credentials>)thisPromise);
        return thisPromise;
    }

    private void getCredentialsInternal(PromiseImpl<Credentials> request) {
        this._storeManager.read().thenCompose(storedCredentials -> this.isPasswordExpired((Credentials)storedCredentials).materialize().thenCompose(prExpired -> {
            if (prExpired.isSuccessful()) {
                if (((Boolean)prExpired.getResult()).booleanValue()) {
                    return this._storeManager.update((Credentials)storedCredentials, this::updateSA);
                }
                return Promises.resolve((Object)storedCredentials);
            }
            Exception exc = prExpired.getError();
            if (!(exc instanceof AuthenticationFailedException)) {
                return Promises.reject((Exception)exc);
            }
            return this._storeManager.read().thenCompose(currentCredentials -> {
                if (storedCredentials.equals(currentCredentials)) {
                    return Promises.reject((Exception)exc);
                }
                return Promises.resolve((Object)currentCredentials);
            });
        })).onError(arg_0 -> request.setError(arg_0)).onSuccess(arg_0 -> request.setResult(arg_0));
    }

    private Promise<Boolean> isPasswordExpired(Credentials storedCredentials) {
        return Promises.from(() -> {
            boolean passExpired = false;
            DrSecurityTokenService sts = SsoFacade.createSts((LsppService)this._ssoReg);
            try {
                sts.acquireToken(storedCredentials.user, storedCredentials.pass, TokenManager.createSpec((long)this.EXP_TIME));
            }
            catch (PasswordExpiredException exc) {
                LOGGER.info("SA password has expired.");
                passExpired = true;
            }
            return passExpired;
        });
    }

    private Promise<Credentials> updateSA(Credentials storedCredentials) {
        VapiServiceImpl service;
        try {
            KeyStore sslStore = CertificateUtils.createTrustStore((Collection)this._vapiEp.getCertificates());
            service = new VapiServiceImpl(this._vapiEp.url, sslStore);
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
        Password passSvc = service.createStub(Password.class);
        AsyncCallbackPromise<PasswordTypes.OutputSpec> result = new AsyncCallbackPromise<PasswordTypes.OutputSpec>();
        result.materialize().onSuccess(unused -> service.dispose());
        PasswordTypes.ChangeSpec spec = new PasswordTypes.ChangeSpec();
        String user = storedCredentials.user.split("@")[0];
        spec.setAccountName(user);
        spec.setOldPassword(storedCredentials.pass.toCharArray());
        passSvc.change(spec, result);
        return result.thenApply(outSpec -> new Credentials(storedCredentials.user, new String(outSpec.getNewPassword())));
    }
}

