/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.oauth2;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationUtils;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.vim.sso.client.SamlToken;
import java.net.URI;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseExchangeController
extends BaseAsyncController {
    private final String _authCode;
    private final Configurator _configurator;

    protected BaseExchangeController(HttpServletRequest request, HttpServletResponse response, String authCode, Configurator configurator) {
        super(request, response);
        this._authCode = authCode;
        this._configurator = configurator;
    }

    @Override
    protected BaseAsyncController.HttpProcessStage createPipeline() {
        return () -> this._configurator.getOAuth2Strategy().thenApply(OAuth2AuthenticationStrategy.class::cast).thenCompose(strategy -> {
            Objects.requireNonNull(strategy, "strategy");
            return strategy.processRequest(this._request, new CompletionStageBuilder((OAuth2AuthenticationStrategy)strategy)).thenApply(builder -> this.getExchangeCodeForJwtToken((OAuth2AuthenticationStrategy)strategy, (CompletionStageBuilder)builder));
        }).toStream();
    }

    private BaseAsyncController.HttpProcessStage getExchangeCodeForJwtToken(OAuth2AuthenticationStrategy strategy, CompletionStageBuilder builder) {
        return () -> OAuth2AuthenticationUtils.exchangeAuthCodeForJwtToken(this._authCode, strategy.getTokenEndpoint(), strategy.getClientId(), strategy.getClientSecret(), this.getRedirectUrl(strategy), strategy.getQueryParams()).toStream().map(response -> this.getExchangeJwtForSamlStage(strategy, response.accessToken, response.idToken, builder.setRefreshToken(response.refreshToken)));
    }

    private BaseAsyncController.HttpProcessStage getExchangeJwtForSamlStage(OAuth2AuthenticationStrategy strategy, String jwtToken, String idToken, CompletionStageBuilder builder) {
        return () -> OAuth2AuthenticationUtils.exchangeJwtForSamlToken(strategy.getVapiEndpoint(), strategy.getSsoContext(), jwtToken, idToken).thenApply(samlToken -> builder.setSamlToken((SamlToken)samlToken).build()).toStream();
    }

    protected abstract URI getRedirectUrl(OAuth2AuthenticationStrategy var1);

    protected Promise<Void> completeLoginRequestProcessing(OAuth2AuthenticationStrategy strategy, String redirectPath, SamlToken samlToken, String refreshToken) {
        return Promises.reject((Exception)new UnsupportedOperationException("completeLoginRequestProcessing"));
    }

    protected Promise<Void> completeRemoteLoginRequestProcessing(OAuth2AuthenticationStrategy strategy, String requestId, String authResponseEndpoint, SamlToken samlToken, String refreshToken) {
        return Promises.reject((Exception)new UnsupportedOperationException("completeRemoteLoginRequestProcessing"));
    }

    private class CompletionStageBuilder
    implements OAuth2AuthenticationStrategy.LoginRequestVisitor<CompletionStageBuilder> {
        final OAuth2AuthenticationStrategy _strategy;
        SamlToken _samlToken;
        String _refreshToken;
        Boolean _isRemoteLogin;
        String _redirectPath;
        String _authResponseEndpoint;
        String _requestId;

        private CompletionStageBuilder(OAuth2AuthenticationStrategy strategy) {
            this._strategy = Objects.requireNonNull(strategy, "strategy");
        }

        CompletionStageBuilder setSamlToken(SamlToken samlToken) {
            this._samlToken = Objects.requireNonNull(samlToken, "samlToken");
            return this;
        }

        CompletionStageBuilder setRefreshToken(String refreshToken) {
            this._refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
            return this;
        }

        CompletionStageBuilder setRedirectPath(String redirectPath) {
            this._redirectPath = Objects.requireNonNull(redirectPath, "redirectPath");
            this._isRemoteLogin = false;
            return this;
        }

        CompletionStageBuilder setAuthResponseEndpoint(String authResponseEndpoint) {
            this._authResponseEndpoint = Objects.requireNonNull(authResponseEndpoint, "authResponseEndpoint");
            this._isRemoteLogin = true;
            return this;
        }

        CompletionStageBuilder setRequestId(String requestId) {
            this._requestId = Objects.requireNonNull(requestId, "requestId");
            this._isRemoteLogin = true;
            return this;
        }

        BaseAsyncController.HttpProcessStage build() {
            return () -> (this._isRemoteLogin != false ? BaseExchangeController.this.completeRemoteLoginRequestProcessing(this._strategy, this._requestId, this._authResponseEndpoint, this._samlToken, this._refreshToken) : BaseExchangeController.this.completeLoginRequestProcessing(this._strategy, this._redirectPath, this._samlToken, this._refreshToken)).toStream().flatMap(unused -> Streams.empty());
        }

        @Override
        public Promise<CompletionStageBuilder> processLogin(String redirectPath) {
            return Promises.resolve((Object)this.setRedirectPath(redirectPath));
        }

        @Override
        public Promise<CompletionStageBuilder> processRemoteLogin(String requestId, String authResponseEndpoint) {
            return Promises.resolve((Object)this.setRequestId(requestId).setAuthResponseEndpoint(authResponseEndpoint));
        }

        @Override
        public Promise<CompletionStageBuilder> processInvalidRequest() {
            return Promises.reject((Exception)new IllegalArgumentException("Invalid request"));
        }
    }
}

