/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.remotelogin;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.infrastructure.authentication.data.RemoteLoginQueryData;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.http.WriteListenerPromise;
import com.vmware.srm.client.infrastructure.init.InitFilter;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLoginQueryServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLoginQueryServlet.class);
    private static final String MIME_TYPE_JSON = "application/json";
    private final boolean _remoteLoginConfigEnabled = Config.get().getExtRemoteLoginEnabled();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this._remoteLoginConfigEnabled) {
            byte[] data = this.serializeResponse(false);
            IOUtils.writeChunked((byte[])data, (OutputStream)response.getOutputStream());
            response.flushBuffer();
            return;
        }
        Configurator configurator = InitFilter.getConfigurator(request);
        RemoteLoginQueryController controller = new RemoteLoginQueryController(request, response, configurator);
        controller.start(Config.get().getResponseTimeout());
    }

    private byte[] serializeResponse(boolean supported) throws IOException {
        RemoteLoginQueryData queryData = new RemoteLoginQueryData();
        queryData.setSupported(supported);
        return SerializationUtil.toByteArray(queryData);
    }

    private class RemoteLoginQueryController
    extends BaseAsyncController {
        private final Configurator _configurator;

        public RemoteLoginQueryController(HttpServletRequest request, HttpServletResponse response, Configurator configurator) {
            super(request, response);
            this._configurator = Objects.requireNonNull(configurator, "Configurator is null");
        }

        @Override
        protected BaseAsyncController.HttpProcessStage createPipeline() {
            ServletOutputStream outputStream;
            this.setResponseHeaders();
            try {
                outputStream = this._response.getOutputStream();
            }
            catch (Exception e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
            WriteListenerPromise writeListener = new WriteListenerPromise(outputStream);
            outputStream.setWriteListener((WriteListener)writeListener);
            return () -> this.getServerSupportsRemoteLogin().thenCompose(serverSupported -> this.sendResult((boolean)serverSupported, writeListener)).onError(exc -> LOGGER.warn("Unable to determine server support.", (Throwable)exc)).toStream().flatMap(unused -> Streams.empty());
        }

        Promise<Boolean> getServerSupportsRemoteLogin() {
            return this._configurator.getOAuth2Strategy().thenApply(OAuth2AuthenticationStrategy.class::cast).thenCompose(strategy -> {
                Objects.requireNonNull(strategy, "OAuth2 strategy is null");
                return strategy.getRemoteLoginVerifier().isSupported();
            });
        }

        Promise<Void> sendResult(boolean serverSupported, WriteListenerPromise writeListener) {
            byte[] data;
            try {
                data = RemoteLoginQueryServlet.this.serializeResponse(serverSupported);
            }
            catch (IOException ioExc) {
                LOGGER.error("Unable to serialize response.", (Throwable)ioExc);
                return Promises.reject((Exception)ioExc);
            }
            return writeListener.setInputBuffer(data);
        }

        private void setResponseHeaders() {
            this._response.setHeader("Content-type", RemoteLoginQueryServlet.MIME_TYPE_JSON);
            this._response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=0");
        }
    }
}

