/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.remotelogin;

import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationUtils;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.http.WriteListenerPromise;
import com.vmware.srm.client.infrastructure.init.InitFilter;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.sso.external.RefreshTokenResponse;
import com.vmware.srm.client.topology.impl.sso.external.jwt.JwtUtils;
import com.vmware.vim.sso.client.SamlToken;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLoginRefreshServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLoginRefreshServlet.class);
    private static final String MIME_TYPE_JSON = "application/json";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String refreshToken;
        String refreshTokenAndExpTime = request.getParameter("refresh_token");
        if (StringUtils.isEmpty((String)refreshTokenAndExpTime)) {
            response.sendError(400);
            return;
        }
        try {
            refreshToken = JwtUtils.verifySignature((String)refreshTokenAndExpTime);
        }
        catch (Exception exc) {
            LOGGER.warn("Token verification failed.", (Throwable)exc);
            response.sendError(400);
            return;
        }
        Configurator configurator = InitFilter.getConfigurator(request);
        RemoteLoginRefreshController controller = new RemoteLoginRefreshController(request, response, configurator, refreshToken);
        controller.start(Config.get().getResponseTimeout());
    }

    private static class RemoteLoginRefreshController
    extends BaseAsyncController {
        private final Configurator _configurator;
        private final String _refreshToken;
        private final WriteListenerPromise _writeListener;

        public RemoteLoginRefreshController(HttpServletRequest request, HttpServletResponse response, Configurator configurator, String refreshToken) {
            super(request, response);
            ServletOutputStream outputStream;
            try {
                outputStream = response.getOutputStream();
            }
            catch (Exception e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
            this._writeListener = new WriteListenerPromise(outputStream);
            this._configurator = configurator;
            this._refreshToken = refreshToken;
        }

        @Override
        protected BaseAsyncController.HttpProcessStage createPipeline() {
            ServletOutputStream outputStream;
            this.setResponseHeaders();
            try {
                outputStream = this._response.getOutputStream();
            }
            catch (Exception e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
            outputStream.setWriteListener((WriteListener)this._writeListener);
            return this::getStrategy;
        }

        Stream<BaseAsyncController.HttpProcessStage> getStrategy() {
            return this._configurator.getOAuth2Strategy().thenApply(strategy -> (OAuth2AuthenticationStrategy)Objects.requireNonNull(strategy, "strategy")).thenApply(strategy -> () -> this.getNewRefreshToken((OAuth2AuthenticationStrategy)strategy)).toStream();
        }

        Stream<BaseAsyncController.HttpProcessStage> getNewRefreshToken(OAuth2AuthenticationStrategy strategy) {
            return OAuth2AuthenticationUtils.refreshJwtToken(strategy.getTokenEndpoint(), strategy.getClientId(), strategy.getClientSecret(), this._refreshToken, strategy.getQueryParams()).thenApply(tokenResponse -> () -> this.exchangeToken(strategy, (OAuth2AuthenticationUtils.OAuth2TokenResponse)tokenResponse)).toStream();
        }

        Stream<BaseAsyncController.HttpProcessStage> exchangeToken(OAuth2AuthenticationStrategy strategy, OAuth2AuthenticationUtils.OAuth2TokenResponse tokenResponse) {
            return OAuth2AuthenticationUtils.exchangeJwtForSamlToken(strategy.getVapiEndpoint(), strategy.getSsoContext(), tokenResponse.accessToken, tokenResponse.idToken).thenApply(samlToken -> () -> this.sendResult((SamlToken)samlToken, tokenResponse.refreshToken)).toStream();
        }

        Stream<BaseAsyncController.HttpProcessStage> sendResult(SamlToken samlToken, String refreshToken) {
            byte[] byteArray;
            long expiresIn = TimeUnit.SECONDS.toMillis(Config.get().getExtRemoteLoginRefreshInt());
            refreshToken = JwtUtils.createJwtToken((String)refreshToken, (Date)new Date(System.currentTimeMillis() + expiresIn));
            RefreshTokenResponse refreshResponse = new RefreshTokenResponse();
            refreshResponse.setSamlTokenAsXml(samlToken.toXml());
            refreshResponse.setRefreshToken(refreshToken);
            try {
                byteArray = SerializationUtil.toByteArray(refreshResponse);
            }
            catch (Exception exc) {
                LOGGER.warn("Failed to serialize response.", (Throwable)exc);
                return Promises.reject((Exception)exc).toStream();
            }
            return this._writeListener.setInputBuffer(byteArray).toStream().flatMap(unused -> Streams.empty());
        }

        private void setResponseHeaders() {
            this._response.setHeader("Content-type", RemoteLoginRefreshServlet.MIME_TYPE_JSON);
            this._response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=0");
        }
    }
}

