/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.remotelogin;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.oauth2.BaseExchangeController;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.http.HttpUtils;
import com.vmware.srm.client.infrastructure.init.InitFilter;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.sso.external.jwt.JwtUtils;
import com.vmware.vim.sso.client.SamlToken;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLoginResponseServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLoginResponseServlet.class);
    private static final String REMOTE_LOGIN_PATH = "/app/remote-login.jsp";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String errorCode = request.getParameter("error");
        if (errorCode != null) {
            LOGGER.error("OAuth2 response contains error: '{}'", (Object)errorCode);
            response.sendError(500);
            return;
        }
        String code = request.getParameter("code");
        Validate.notNull((Object)code, (String)"code");
        Configurator configurator = InitFilter.getConfigurator(request);
        RemoteLoginExchangeController controller = new RemoteLoginExchangeController(request, response, code, configurator);
        controller.start(Config.get().getResponseTimeout());
    }

    private static class RemoteLoginExchangeController
    extends BaseExchangeController {
        protected RemoteLoginExchangeController(HttpServletRequest request, HttpServletResponse response, String authCode, Configurator configurator) {
            super(request, response, authCode, configurator);
        }

        @Override
        protected URI getRedirectUrl(OAuth2AuthenticationStrategy strategy) {
            return strategy.getRemoteLoginRedirectUrl();
        }

        @Override
        protected Promise<Void> completeRemoteLoginRequestProcessing(OAuth2AuthenticationStrategy strategy, String requestId, String authResponseEndpoint, SamlToken samlToken, String refreshToken) {
            this._request.setAttribute("h5dr.remotelogin.responseendpoint", (Object)authResponseEndpoint);
            this._request.setAttribute("h5dr.remotelogin.requestid", (Object)requestId);
            this._request.setAttribute("h5dr.remotelogin.samltoken", (Object)this.encodeSamlToken(samlToken));
            this._request.setAttribute("h5dr.remotelogin.refreshtoken", (Object)this.createRefreshResponseToken(refreshToken));
            this._response.setHeader("Content-type", "text/html");
            HttpUtils.setNoCache(this._response);
            RequestDispatcher view = this._request.getRequestDispatcher(RemoteLoginResponseServlet.REMOTE_LOGIN_PATH);
            try {
                view.include((ServletRequest)this._request, (ServletResponse)this._response);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to dispatch request to 'remote-login.jsp'", (Throwable)e);
                return Promises.reject((Exception)e);
            }
            return Promises.resolve(null);
        }

        private String encodeSamlToken(SamlToken samlToken) {
            String xmlToken = samlToken.toXml();
            return Base64.getEncoder().encodeToString(xmlToken.getBytes(StandardCharsets.UTF_8));
        }

        private String createRefreshResponseToken(String refreshToken) {
            long expiresIn = TimeUnit.SECONDS.toMillis(Config.get().getExtRemoteLoginRefreshInt());
            return JwtUtils.createJwtToken((String)refreshToken, (Date)new Date(System.currentTimeMillis() + expiresIn));
        }
    }
}

