/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http;

import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.http.WriteListenerPromise;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncControllerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncControllerUtils.class);

    public static BaseAsyncController.HttpProcessStage createSendStage(byte[] toSend, HttpServletResponse response, WriteListenerPromise promise) {
        response.addHeader("Content-type", "application/json");
        promise.setInputBuffer(toSend);
        return () -> promise.toStream().flatMap(unused -> Streams.empty());
    }

    public static BaseAsyncController.HttpProcessStage createErrorStage(Exception e) {
        LOGGER.error("Creating error stage.", (Throwable)e);
        return () -> Promises.reject((Exception)e).toStream();
    }
}

