/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.init;

import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.L10NHelper;
import com.vmware.dr.ui.tools.utilities.OpIdAccessor;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import com.vmware.dr.ui.tools.utilities.threadcontexthelpers.LogContextSetter;
import com.vmware.srm.client.infrastructure.health.HealthCheckController;
import com.vmware.srm.client.infrastructure.health.HealthChecker;
import com.vmware.srm.client.infrastructure.http.HttpUtils;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;

public class InitFilter
implements Filter {
    private static final String CHAR_ENCODING = "UTF-8";
    private static final String HEALTH_PATH = "health";
    private static final String INIT_CONFIG_ATTRIB = "dr.ui.init.config";
    private static final String DIAGNOSTICS_REMOTE_ADDR = "drRemoteAddress";
    private final Configurator _configurator = new Configurator();
    private final HealthChecker _healthChecker = new HealthChecker(this._configurator);

    private static String generateOpId() {
        return UUID.randomUUID().toString();
    }

    public static Configurator getConfigurator(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"request");
        Configurator config = (Configurator)request.getAttribute(INIT_CONFIG_ATTRIB);
        if (config == null) {
            throw new RuntimeException("No configurator in request " + request.getRequestURI());
        }
        return config;
    }

    public void init(FilterConfig filterConfig) {
        String opId = InitFilter.generateOpId();
        OpIdAccessor.withOpId(this._configurator::start, (String)opId).run();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.executeInContext(request, response, chain);
    }

    private void executeInContext(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Callable task = () -> {
            this.doFilterInternal(request, response, chain);
            return null;
        };
        task = L10NHelper.withLocale(task, (Locale)request.getLocale());
        task = OpIdAccessor.withOpId((Callable)task, (String)InitFilter.generateOpId());
        String remoteAddr = request.getRemoteHost() + ":" + request.getRemotePort();
        try {
            ThreadContext.setupContext((Callable)task, (ContextApplier)LogContextSetter.createApplier((String)DIAGNOSTICS_REMOTE_ADDR, (Object)remoteAddr));
        }
        catch (IOException | ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(request) || !HttpServletResponse.class.isInstance(response)) {
            response.flushBuffer();
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setCharacterEncoding(CHAR_ENCODING);
        if ("GET".equals(httpRequest.getMethod()) && HEALTH_PATH.equals(HttpUtils.getPath(httpRequest))) {
            HealthCheckController controller = new HealthCheckController(httpRequest, httpResponse, this._healthChecker::check);
            controller.start(Config.get().getResponseTimeout());
            return;
        }
        httpRequest.setAttribute(INIT_CONFIG_ATTRIB, (Object)this._configurator);
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }
}

