/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.localization;

import com.vmware.dr.ui.tools.utilities.L10NHelper;
import com.vmware.srm.client.infrastructure.localization.catalogManager.CatalogLoader;
import com.vmware.srm.client.infrastructure.localization.catalogManager.CatalogLookup;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.fault.ExtendedFault;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalizationUtil.class);
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static volatile CatalogLoader LOADER;
    private static volatile CatalogLookup LOOK_UP;
    private static final String VC_PACKAGE = "com.vmware.vim.binding.vim";
    private static final String SRM_FAULT_KEY_PREFIX = "com.vmware.vcDr.";
    private static final String HMS_FAULT_KEY_PREFIX = "com.vmware.vcHms.";
    private static final String SUMMARY_KEY_SUFFIX = ".summary";
    private static final String HMS_METHOD_FAULT_ID = "com.vmware.vcHms.hms.fault.HmsMethodFault";
    private static final String PROP_GROUP = "prop";
    private static final String ENUM_TYPE_GROUP = "type";
    private static final String VC_PROPERTY_PLACEHOLDER = "\\{\\s?((?<prop>\\w+)(\\.@enum\\.(?<type>\\w+(\\.\\w+)*))?)(\\.\\w+)*\\s?}";
    private static final Pattern VC_PROP;
    private static final Pattern DATA_PROP;

    static void init(String baseDir) {
        LOADER = new CatalogLoader(baseDir);
        LocalizationUtil.reload();
    }

    public static boolean reload() {
        if (LOADER == null) {
            throw new IllegalStateException("LOADER");
        }
        try {
            LOOK_UP = new CatalogLookup(LOADER.load(), DEFAULT_LOCALE);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Failed to reload catalogs", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getLocalizedMessage(String key) {
        return LocalizationUtil.getLocalizedMessageGivenLocale(key, L10NHelper.getLocale());
    }

    private static String getLocalizedMessageGivenLocale(String key, Locale locale) {
        return LOOK_UP.getLocalizedMessage(locale, key);
    }

    public static String getLocalizedMessage(Exception fault) {
        return LocalizationUtil.getLocalizedMessage(fault, L10NHelper.getLocale());
    }

    private static String getVcLocalizedMessage(Exception fault, Locale locale) {
        String messageTemplate;
        Validate.notNull((Object)fault);
        if (!(fault instanceof MethodFault) && !(fault instanceof RuntimeFault)) {
            return fault.getMessage();
        }
        String faultKey = fault.getClass().getSimpleName() + SUMMARY_KEY_SUFFIX;
        if (faultKey.equals(messageTemplate = LOOK_UP.getLocalizedMessage(locale, faultKey))) {
            return fault.getMessage();
        }
        Matcher m = VC_PROP.matcher(messageTemplate);
        if (m.find()) {
            StringBuffer sb = new StringBuffer(2 * messageTemplate.length());
            do {
                String property = m.group(PROP_GROUP);
                String enumType = m.group(ENUM_TYPE_GROUP);
                String value = LocalizationUtil.getPropertyValue(fault, property).toString();
                if (enumType == null) {
                    m.appendReplacement(sb, value);
                    continue;
                }
                String enumKey = enumType + "." + value + SUMMARY_KEY_SUFFIX;
                String msg = LOOK_UP.getLocalizedMessage(locale, enumKey);
                m.appendReplacement(sb, msg);
            } while (m.find());
            m.appendTail(sb);
            return sb.toString();
        }
        return messageTemplate;
    }

    private static Object getPropertyValue(Throwable throwable, String propName) {
        try {
            return PropertyUtils.getProperty((Object)throwable, (String)propName);
        }
        catch (Exception exc) {
            LOGGER.warn("Failed to read property '{}' of '{}'", (Object)propName, (Object)throwable);
            return propName;
        }
    }

    private static String getHmsLocalizedMessage(Throwable fault, Locale locale) {
        String messageTemplate;
        Exception cause;
        Validate.notNull((Object)fault);
        if (!(fault instanceof ExtendedFault)) {
            return fault.getMessage();
        }
        ExtendedFault extendedFault = (ExtendedFault)fault;
        String id = extendedFault.getFaultTypeId();
        if (HMS_METHOD_FAULT_ID.equals(id) && (cause = extendedFault.getFaultCause()) != null && cause != extendedFault) {
            return LocalizationUtil.getLocalizedMessage(cause, locale);
        }
        String key = id + SUMMARY_KEY_SUFFIX;
        if (key.equals(messageTemplate = LOOK_UP.getLocalizedMessage(locale, key))) {
            return extendedFault.getMessage();
        }
        Map<String, String> dataValueByKey = LocalizationUtil.getDataPropertyValueByKey(extendedFault);
        Matcher m = DATA_PROP.matcher(messageTemplate);
        if (m.find()) {
            StringBuffer sb = new StringBuffer(messageTemplate.length() + dataValueByKey.size() * 10);
            do {
                String nextKey = m.group(PROP_GROUP);
                m.appendReplacement(sb, dataValueByKey.getOrDefault(nextKey, nextKey));
            } while (m.find());
            m.appendTail(sb);
            return sb.toString();
        }
        return messageTemplate;
    }

    private static String getSrmLocalizedMessage(Exception fault, Locale locale) {
        String messageTemplate;
        Validate.notNull((Object)fault);
        if (!(fault instanceof ExtendedFault)) {
            return fault.getMessage();
        }
        ExtendedFault extendedFault = (ExtendedFault)fault;
        if (!extendedFault.getFaultTypeId().startsWith(SRM_FAULT_KEY_PREFIX)) {
            return extendedFault.getMessage();
        }
        String key = extendedFault.getFaultTypeId() + SUMMARY_KEY_SUFFIX;
        if (key.equals(messageTemplate = LOOK_UP.getLocalizedMessage(locale, key))) {
            return extendedFault.getMessage();
        }
        Map<String, MethodFault> faultByKey = LocalizationUtil.getNestedFaultsByKey(extendedFault);
        Map<String, String> dataValueByKey = LocalizationUtil.getDataPropertyValueByKey(extendedFault);
        if (faultByKey.isEmpty() && dataValueByKey.isEmpty()) {
            return extendedFault.getMessage();
        }
        Matcher m = DATA_PROP.matcher(messageTemplate);
        if (m.find()) {
            StringBuffer sb = new StringBuffer(messageTemplate.length() + (faultByKey.size() + dataValueByKey.size()) * 10);
            do {
                String nextKey;
                MethodFault mf;
                if ((mf = faultByKey.get(nextKey = m.group(PROP_GROUP))) == null) {
                    m.appendReplacement(sb, dataValueByKey.getOrDefault(nextKey, nextKey));
                    continue;
                }
                m.appendReplacement(sb, LocalizationUtil.getLocalizedMessage((Exception)mf, locale));
            } while (m.find());
            m.appendTail(sb);
            return sb.toString();
        }
        return extendedFault.getMessage();
    }

    public static String getLocalizedMessage(Exception fault, Locale locale) {
        Validate.notNull((Object)fault, (String)"fault");
        if (fault instanceof ExtendedFault) {
            ExtendedFault ef = (ExtendedFault)fault;
            if (ef.getFaultTypeId().startsWith(SRM_FAULT_KEY_PREFIX)) {
                return LocalizationUtil.getSrmLocalizedMessage((Exception)ef, locale);
            }
            if (ef.getFaultTypeId().startsWith(HMS_FAULT_KEY_PREFIX)) {
                return LocalizationUtil.getHmsLocalizedMessage((Throwable)ef, locale);
            }
        }
        if (fault.getClass().getCanonicalName().startsWith(VC_PACKAGE)) {
            return LocalizationUtil.getVcLocalizedMessage(fault, locale);
        }
        return fault.getMessage();
    }

    private static Map<String, String> getDataPropertyValueByKey(ExtendedFault fault) {
        Object[] params = fault.getData();
        if (ArrayUtils.isEmpty((Object[])params)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(params).collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
    }

    private static Map<String, MethodFault> getNestedFaultsByKey(ExtendedFault fault) {
        Object[] messageArray = fault.getFaultMessage();
        if (ArrayUtils.isEmpty((Object[])messageArray)) {
            return Collections.emptyMap();
        }
        LocalizableMessage message = Arrays.stream(messageArray).filter(msg -> fault.getFaultTypeId().equals(msg.getKey())).findFirst().orElse(null);
        if (message == null) {
            return Collections.emptyMap();
        }
        Object[] faults = message.getArg();
        if (ArrayUtils.isEmpty((Object[])faults)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(faults).filter(kav -> kav.getValue() instanceof MethodFault && kav.getValue() != fault).collect(Collectors.toMap(KeyAnyValue::getKey, kav -> (MethodFault)kav.getValue()));
    }

    static {
        LOOK_UP = new CatalogLookup(CatalogLoader.EMPTY, DEFAULT_LOCALE);
        VC_PROP = Pattern.compile(VC_PROPERTY_PLACEHOLDER);
        DATA_PROP = Pattern.compile("\\[data\\.(?<prop>(\\w+\\.*)+)]");
    }
}

