/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.impl;

import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import com.vmware.srm.client.reactive.impl.request.RequestContext;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestErrorListener
implements ServletRequestAttributeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestErrorListener.class);

    public void attributeAdded(ServletRequestAttributeEvent event) {
        this.handleEvent(event);
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        this.handleEvent(event);
    }

    private void handleEvent(ServletRequestAttributeEvent event) {
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        if ("javax.servlet.error.exception".equals(event.getName()) && event.getValue() instanceof Throwable) {
            RequestContext rc = (RequestContext)request.getAttribute("com.vmware.dr.requestcontext");
            Throwable t = (Throwable)event.getValue();
            if (rc != null) {
                LOGGER.debug("Completing request '{}' :", (Object)request.getRequestURI(), (Object)t);
                rc.end(Exceptions.wrap((Throwable)t));
            }
        } else if ("com.vmware.dr.requestcontext".equals(event.getName())) {
            Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
            if (t == null) {
                return;
            }
            LOGGER.debug("Completing request '{}' :", (Object)request.getRequestURI(), (Object)t);
            RequestContext rc = (RequestContext)event.getValue();
            rc.end(Exceptions.wrap((Throwable)t));
        }
    }
}

