/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.srm.client.infrastructure.commonData.ProtectionGroupState;
import com.vmware.vim.binding.dr.replication.ProtectedVm;
import com.vmware.vim.binding.dr.replication.ProtectionGroup;

public class ProtectionGroupUtil {
    public static boolean isProtectionGroupInProtectedSiteState(ProtectionGroup.State state) {
        boolean result = false;
        switch (state) {
            case active: 
            case deactivating: 
            case partiallyDeactivated: 
            case deactivated: 
            case restoring: 
            case partiallyRestored: 
            case reprotectBegun: 
            case reprotectedSource: 
            case reversedReplication: {
                result = true;
                break;
            }
            case shadowing: 
            case recovering: 
            case partiallyRecovered: 
            case recovered: 
            case demoting: 
            case partiallyDemoted: 
            case reversingReplication: 
            case partiallyReversedReplication: 
            case reprotectedDest: 
            case terminalRecovering: 
            case partiallyTerminalRecovered: 
            case terminalRecovered: 
            case startingTest: 
            case testing: 
            case finishingTest: {
                result = false;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported state - [%s].", state));
            }
        }
        return result;
    }

    public static boolean isProtectionGroupInProtectedSiteState(ProtectionGroupState customState) {
        return ProtectionGroupUtil.isProtectionGroupInProtectedSiteState(customState.toState());
    }

    public static boolean isProtectedVmInProtectedSiteState(ProtectedVm.State state) {
        if (state == null) {
            return false;
        }
        boolean result = false;
        switch (state) {
            case active: 
            case deactivating: 
            case partiallyDeactivated: 
            case deactivated: 
            case restoring: 
            case partiallyRestored: 
            case reprotectBegun: {
                result = true;
                break;
            }
            case shadowing: 
            case recovering: 
            case partiallyRecovered: 
            case recovered: 
            case demoting: 
            case partiallyDemoted: 
            case reversingReplication: 
            case partiallyReversedReplication: 
            case reversedReplication: 
            case terminalRecovering: 
            case partiallyTerminalRecovered: 
            case terminalRecovered: 
            case startingTest: 
            case testing: 
            case finishingTest: {
                result = false;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported state - [%s].", state));
            }
        }
        return result;
    }
}

