/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.srm.client.infrastructure.utils.ManagedObjectUtil;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;

public class VcVmodlUtil {
    private static final String VM_FOLDER_VALUE = "group-v";
    private static final String NETWORK_FOLDER_VALUE = "group-n";
    private static final String HOST_FOLDER_VALUE = "group-h";
    private static final String DATASTORE_FOLDER_VALUE = "group-s";
    private static final String DATACENTER_FOLDER_VALUE = "group-d";
    private static final String VC_CLIENT_FOLDER_ROOT_NAME = "group-d1";

    public static boolean isRootFolder(ManagedObjectReference entity) {
        return ManagedObjectUtil.isOfType(entity, Folder.class) && entity.getValue().equals(VC_CLIENT_FOLDER_ROOT_NAME);
    }

    public static ManagedObjectReference getRootFolder(String serverGuid) {
        return ClientUtils.createMoRef((String)"Folder", (String)VC_CLIENT_FOLDER_ROOT_NAME, (String)serverGuid);
    }

    public static boolean isNetworkFolder(ManagedObjectReference entity) {
        return ManagedObjectUtil.isOfType(entity, Folder.class) && entity.getValue().contains(NETWORK_FOLDER_VALUE);
    }

    public static boolean isHostFolder(ManagedObjectReference entity) {
        return ManagedObjectUtil.isOfType(entity, Folder.class) && entity.getValue().contains(HOST_FOLDER_VALUE);
    }

    public static boolean isStorageFolder(ManagedObjectReference entity) {
        return ManagedObjectUtil.isOfType(entity, Folder.class) && entity.getValue().contains(DATASTORE_FOLDER_VALUE);
    }

    public static boolean isDatacenterFolder(ManagedObjectReference entity) {
        return ManagedObjectUtil.isOfType(entity, Folder.class) && entity.getValue().contains(DATACENTER_FOLDER_VALUE);
    }

    public static boolean isVmFolder(ManagedObjectReference entity) {
        return ManagedObjectUtil.isOfType(entity, Folder.class) && entity.getValue().contains(VM_FOLDER_VALUE);
    }
}

