/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websockets;

import com.vmware.srm.client.infrastructure.websockets.endpoint.DrWsServerEndpoint;
import java.util.Collections;
import java.util.Set;
import javax.websocket.Endpoint;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrWsAppConfig
implements ServerApplicationConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrWsAppConfig.class);

    private static ServerEndpointConfig createConfig(Class<? extends Endpoint> epClass) {
        ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(epClass, (String)"/live");
        builder.configurator((ServerEndpointConfig.Configurator)new Config());
        return builder.build();
    }

    public Set<ServerEndpointConfig> getEndpointConfigs(Set<Class<? extends Endpoint>> scanned) {
        if (!scanned.contains(DrWsServerEndpoint.class)) {
            LOGGER.error("'{}' not discovered by container. Discovered: '{}'.", DrWsServerEndpoint.class, scanned);
            return Collections.emptySet();
        }
        ServerEndpointConfig config = scanned.stream().filter(DrWsServerEndpoint.class::equals).findFirst().map(DrWsAppConfig::createConfig).orElseThrow(RuntimeException::new);
        return Collections.singleton(config);
    }

    public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
        return Collections.emptySet();
    }

    private static class Config
    extends ServerEndpointConfig.Configurator {
        private Config() {
        }

        public <T> T getEndpointInstance(Class<T> clazz) {
            Validate.isTrue((boolean)DrWsServerEndpoint.class.equals(clazz));
            return (T)((Object)DrWsServerEndpoint.get());
        }

        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            super.modifyHandshake(sec, request, response);
            sec.getUserProperties().put("dr.ws.httpsession", request.getHttpSession());
        }
    }
}

