/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.security.impl;

import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.core.security.SignInfo;
import java.security.PrivateKey;

public class SignInfoImpl
implements SignInfo {
    public static final int DEFAULT_MESSAGE_VALIDITY = 600;
    private SamlToken _token;
    private PrivateKey _key;
    private Integer _messageValidity;

    public SignInfoImpl(PrivateKey key, SamlToken token, int messageValidity) {
        if (token == null) {
            throw new IllegalArgumentException("SAML token is required for signing.");
        }
        if (ConfirmationType.HOLDER_OF_KEY == token.getConfirmationType() && key == null) {
            throw new IllegalArgumentException("Private key is required for signing with HOLDER_OF_KEY SAML token.");
        }
        if (ConfirmationType.BEARER == token.getConfirmationType() && key != null) {
            throw new IllegalArgumentException("Private key is not supported for BEARER token.");
        }
        if (messageValidity <= 0) {
            throw new IllegalArgumentException("Message validity should be > 0.");
        }
        this._key = key;
        this._token = token;
        this._messageValidity = messageValidity;
    }

    public SignInfoImpl(PrivateKey key, SamlToken token) {
        this(key, token, 600);
    }

    @Override
    public SamlToken getSamlToken() {
        return this._token;
    }

    @Override
    public PrivateKey getSignerPrivateKey() {
        return this._key;
    }

    @Override
    public int getMessageValidity() {
        return this._messageValidity;
    }
}

