/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.Environment;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContextFactory;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

class ComplexStackContext
extends StackContext {
    private Object _value;
    private final Environment _env;

    public ComplexStackContext(VmodlField field, VmodlType type, StackContext parent, Environment env) throws UnmarshallException {
        super(field, type, parent);
        this._env = env;
        try {
            this._value = env.getDataObjectFactory().newDataObject(env.getContext(), env.getTypeMap(), env.getVersion(), (ComplexType)type);
        }
        catch (InstantiationException e) {
            throw new UnmarshallException(String.format("Failed to create new instance of '%s'", type.getWsdlName()), e);
        }
    }

    @Override
    public void setValue(Object value) {
        throw new InternalException(String.format("Complex field contains illegal content: '%1$s'", value));
    }

    @Override
    public void setChildValue(VmodlField field, Object value) throws UnmarshallException {
        ComplexTypeField complexField = (ComplexTypeField)field;
        complexField.set(this._value, value);
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public void close() throws UnmarshallException {
        StackContext parent = this.getParentContext();
        if (parent != null) {
            parent.setChildValue(this.getField(), this._value);
        }
        this.validateDataObject();
    }

    @Override
    public StackContext getNestedContext(QName name2, Map<QName, String> attrs, NamespaceContext namespaces) throws UnmarshallException {
        ComplexType complexType = (ComplexType)this.getType();
        ComplexTypeField nestedField = complexType.getProperty(name2.getLocalPart());
        if (nestedField == null) {
            throw new UnmarshallException(String.format("Type '%1$s' contains unrecognized property '%2$s'", complexType.getWsdlName(), name2.getLocalPart()));
        }
        return StackContextFactory.newContext(this, nestedField, name2, attrs, namespaces, this._env);
    }

    private void validateDataObject() throws UnmarshallException {
        ComplexType complexType = (ComplexType)this._env.getTypeMap().getDynamicVmodlType(this._value);
        for (ComplexTypeField f : complexType.getProperties()) {
            if (f.isOptional() || f.get(this._value) != null) continue;
            throw new UnmarshallException("Missing value for non-optional field " + f.getName());
        }
    }
}

