/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.arrayManagers;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeArrayPair;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.storage.REPLICATED_ARRAY_PAIR;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;

public class ArrayPairConverter
implements ConfigurableConverter {
    public static List<IeArrayPair> fromVmodl(ManagedObjectReference[] arrayPairs, PcResult pcResult) {
        if (ArrayUtils.isEmpty((Object[])arrayPairs)) {
            return Collections.emptyList();
        }
        return Arrays.stream(arrayPairs).map(arrayPair -> {
            String key = (String)pcResult.getProperty(arrayPair, REPLICATED_ARRAY_PAIR.INFO_.KEY);
            String peerKey = (String)pcResult.getProperty(arrayPair, REPLICATED_ARRAY_PAIR.PEER_.ARRAY_ID);
            return new IeArrayPair(key, peerKey);
        }).collect(Collectors.toList());
    }
}

