/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.inventory;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.inventory.IeInventory;
import com.vmware.srm.client.impex.configurables.inventory.IeInventoryFolder;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.DatacenterConverter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.DistributedVirtualPortgroupConverter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeVirtualMachine;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.NetworkConverter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.VirtualMachineConverterBase;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.computeRes.ComputeResourceConverter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.computeRes.IeComputeResource;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.resPool.IeResourcePool;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.resPool.ResourcePoolConverter;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.vim.VIRTUAL_MACHINE;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryConverter.class);

    public static ManagedObjectReference getRootFolder(String serverGuid) {
        return ClientUtils.createMoRef((String)"Folder", (String)"group-d1", (String)serverGuid);
    }

    public static PropertyCollector.FilterSpec getFilterSpec(String vcGuid) {
        return InventoryConverter.getFilterSpec(vcGuid, new PropsProvider());
    }

    public static PropertyCollector.FilterSpec getFilterSpec(String vcGuid, PropsProvider propsProvider) {
        PropertyCollector.PropertySpec vmPropertySpec = PCUtil.createPropertySpec((String)"VirtualMachine", (String[])propsProvider.getVmProperties());
        PropertyCollector.PropertySpec folderPropertySpec = PCUtil.createPropertySpec((String)"Folder", (String[])new String[]{"name", "childEntity"});
        PropertyCollector.PropertySpec dcPropertySpec = PCUtil.createPropertySpec((String)"Datacenter", (String[])new String[]{"name", "vmFolder", "networkFolder", "datastore", "hostFolder"});
        PropertyCollector.PropertySpec networkPropertySpec = PCUtil.createPropertySpec((String)"Network", (String[])new String[]{"name", "tag"});
        PropertyCollector.PropertySpec datastorePropertySpec = PCUtil.createPropertySpec((String)"Datastore", (String[])new String[]{"name"});
        PropertyCollector.PropertySpec computeResourcePropertySpec = PCUtil.createPropertySpec((String)"ComputeResource", (String[])new String[]{"name", "host", "resourcePool"});
        PropertyCollector.PropertySpec hostSystemPropertySpec = PCUtil.createPropertySpec((String)"HostSystem", (String[])new String[]{"name"});
        PropertyCollector.PropertySpec resourcePoolPropertySpec = PCUtil.createPropertySpec((String)"ResourcePool", (String[])propsProvider.getResPoolProperties());
        ManagedObjectReference rootFolder = InventoryConverter.getRootFolder(vcGuid);
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(rootFolder);
        ObjectSpecBuilder.TraversalSpecBuilder rootTraversal = specBuilder.traverseTo("childEntity");
        ObjectSpecBuilder.TraversalSpecBuilder dcTraversal = rootTraversal.traverseTo("Datacenter", "vmFolder");
        ObjectSpecBuilder.TraversalSpecBuilder networkTraversal = rootTraversal.traverseTo("Datacenter", "networkFolder");
        ObjectSpecBuilder.TraversalSpecBuilder datastoreTraversal = rootTraversal.traverseTo("Datacenter", "datastore");
        ObjectSpecBuilder.TraversalSpecBuilder computeResourceTraversal = rootTraversal.traverseTo("Datacenter", "hostFolder");
        ObjectSpecBuilder.TraversalSpecBuilder hostSystemTraversal = rootTraversal.traverseTo("ComputeResource", "host");
        ObjectSpecBuilder.TraversalSpecBuilder computeResourcePoolTraversal = rootTraversal.traverseTo("ComputeResource", "resourcePool");
        ObjectSpecBuilder.TraversalSpecBuilder resourcePoolPoolTraversal = computeResourcePoolTraversal.traverseTo("ResourcePool", "resourcePool");
        resourcePoolPoolTraversal.traverseTo("ResourcePool", "vm");
        rootTraversal.loopTo(rootTraversal.getName());
        rootTraversal.loopTo(dcTraversal.getName());
        rootTraversal.loopTo(networkTraversal.getName());
        rootTraversal.loopTo(datastoreTraversal.getName());
        rootTraversal.loopTo(computeResourceTraversal.getName());
        rootTraversal.loopTo(computeResourcePoolTraversal.getName());
        rootTraversal.loopTo(resourcePoolPoolTraversal.getName());
        dcTraversal.loopTo(rootTraversal.getName());
        networkTraversal.loopTo(rootTraversal.getName());
        datastoreTraversal.loopTo(rootTraversal.getName());
        computeResourceTraversal.loopTo(rootTraversal.getName());
        computeResourcePoolTraversal.loopTo(rootTraversal.getName());
        hostSystemTraversal.loopTo(rootTraversal.getName());
        computeResourcePoolTraversal.loopTo(computeResourcePoolTraversal.getName());
        resourcePoolPoolTraversal.loopTo(resourcePoolPoolTraversal.getName());
        return new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{vmPropertySpec, folderPropertySpec, dcPropertySpec, networkPropertySpec, datastorePropertySpec, computeResourcePropertySpec, hostSystemPropertySpec, resourcePoolPropertySpec}, new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
    }

    public static <V extends IeVirtualMachine, C extends VirtualMachineConverterBase<V>, P extends IeResourcePool<V, P>, R extends IeComputeResource<V, P>> IeInventoryFolder rootFromVmodl(IdBuilder idBuilder, PcResult pcResult, String vcGuid, C vmConverter, ResourcePoolConverter<V, C, P> resPoolConverter, ComputeResourceConverter<V, C, P, R> computeResConverter) {
        IeInventoryFolder ieRoot = new IeInventoryFolder();
        ieRoot.setId(idBuilder.buildRootFolderId(vcGuid));
        if (pcResult == null || vcGuid == null) {
            return ieRoot;
        }
        ManagedObjectReference root = InventoryConverter.getRootFolder(vcGuid);
        ieRoot.setName((String)pcResult.getProperty(root, root.getValue()));
        ieRoot.setChildren(InventoryConverter.fromVmodl(idBuilder, pcResult, (ManagedObjectReference[])pcResult.getProperty(root, "childEntity"), vmConverter, resPoolConverter, computeResConverter));
        return ieRoot;
    }

    public static <V extends IeVirtualMachine, C extends VirtualMachineConverterBase<V>, P extends IeResourcePool<V, P>, R extends IeComputeResource<V, P>> List<IeInventory> fromVmodl(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference[] entities, C vmConverter, ResourcePoolConverter<V, C, P> resPoolConverter, ComputeResourceConverter<V, C, P, R> computeResConverter) {
        if (ArrayUtils.isEmpty((Object[])entities)) {
            return Collections.emptyList();
        }
        return Arrays.stream(entities).map(entity -> {
            switch (entity.getType()) {
                case "Folder": {
                    return InventoryConverter.folderFromVmodl(idBuilder, pcResult, entity, vmConverter, resPoolConverter, computeResConverter);
                }
                case "VirtualMachine": {
                    return vmConverter.fromVmodl(idBuilder, pcResult, (ManagedObjectReference)entity);
                }
                case "Datacenter": {
                    return DatacenterConverter.fromVmodl(idBuilder, pcResult, entity, vmConverter, resPoolConverter, computeResConverter);
                }
                case "ComputeResource": 
                case "ClusterComputeResource": {
                    return computeResConverter.fromVmodl(idBuilder, pcResult, (ManagedObjectReference)entity);
                }
                case "VirtualApp": {
                    return resPoolConverter.fromVmodl(idBuilder, pcResult, (ManagedObjectReference)entity, vmConverter);
                }
                case "Network": 
                case "OpaqueNetwork": {
                    return NetworkConverter.fromVmodl(idBuilder, pcResult, entity);
                }
                case "DistributedVirtualPortgroup": {
                    return DistributedVirtualPortgroupConverter.fromVmodl(idBuilder, pcResult, entity);
                }
            }
            LOGGER.warn("Unexpected entity type: {}.", entity);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static <V extends IeVirtualMachine, C extends VirtualMachineConverterBase<V>, P extends IeResourcePool<V, P>, R extends IeComputeResource<V, P>> IeInventoryFolder folderFromVmodl(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference entity, C vmConverter, ResourcePoolConverter<V, C, P> resPoolConverter, ComputeResourceConverter<V, C, P, R> computeResConverter) {
        IeInventoryFolder folder = new IeInventoryFolder();
        folder.setName((String)pcResult.getProperty(entity, "name"));
        folder.setId(idBuilder.buildId(entity));
        folder.setChildren(InventoryConverter.fromVmodl(idBuilder, pcResult, (ManagedObjectReference[])pcResult.getProperty(entity, "childEntity"), vmConverter, resPoolConverter, computeResConverter));
        return folder;
    }

    public static class PropsProvider {
        private static final String[] VM_PROPERTIES = new String[]{"name", VIRTUAL_MACHINE.CONFIG_.INSTANCE_UUID};
        private static final String[] RES_POOL_PROPERTIES = new String[]{"name", "resourcePool", "vm"};

        protected String[] getVmProperties() {
            return VM_PROPERTIES;
        }

        protected String[] getResPoolProperties() {
            return RES_POOL_PROPERTIES;
        }
    }
}

