/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.mappings;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.mappings.IeIPCustomizationRule;
import com.vmware.srm.client.impex.configurables.mappings.IeRuleIPSettings;
import com.vmware.srm.client.impex.configurables.mappings.IpMappingConverter;
import com.vmware.vim.binding.dr.IPMapping;
import com.vmware.vim.binding.dr.IpSubnetMapper;
import com.vmware.vim.binding.vim.vm.customization.FixedIp;
import com.vmware.vim.binding.vim.vm.customization.IPSettings;
import com.vmware.vim.binding.vim.vm.customization.IpGenerator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpCustomizationRuleConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpCustomizationRuleConverter.class);

    public static IeIPCustomizationRule[] fromVmodl(IpSubnetMapper.IPSubnetMapping[] mappings, ManagedObjectReference primaryObject, ManagedObjectReference secondaryObject) {
        IPMapping mapping = IpMappingConverter.toVmodl(mappings, primaryObject, secondaryObject);
        if (mapping == null) {
            return null;
        }
        Object[] rules = mapping.getRules();
        if (ArrayUtils.isEmpty((Object[])rules)) {
            return null;
        }
        return (IeIPCustomizationRule[])Arrays.stream(rules).map(IpCustomizationRuleConverter::fromVmodl).toArray(IeIPCustomizationRule[]::new);
    }

    public static IPMapping toVmodl(IeIPCustomizationRule[] rules, String mapperGuid) {
        if (rules == null) {
            LOGGER.debug("IeRules are null for mapper with guid: {}.", (Object)mapperGuid);
            return null;
        }
        Object[] subnetRules = IpCustomizationRuleConverter.convertSubnetRules(rules);
        if (ArrayUtils.isEmpty((Object[])subnetRules)) {
            LOGGER.debug("Subnet rules are null for mapper with guid: {}.", (Object)mapperGuid);
            return null;
        }
        IPMapping ipMapping = new IPMapping();
        ipMapping.setRules((IPMapping.SubnetRule[])subnetRules);
        ipMapping.name = subnetRules[0].getName();
        return ipMapping;
    }

    private static IeIPCustomizationRule fromVmodl(IPMapping.SubnetRule rule) {
        if (rule == null) {
            return new IeIPCustomizationRule();
        }
        IPSettings settings = rule.remoteIPSettings;
        if (settings == null) {
            return new IeIPCustomizationRule(rule, null);
        }
        return new IeIPCustomizationRule(rule, new IeRuleIPSettings(settings));
    }

    private static IPMapping.SubnetRule[] convertSubnetRules(IeIPCustomizationRule[] ieRules) {
        return (IPMapping.SubnetRule[])Arrays.stream(ieRules).map(IpCustomizationRuleConverter::convertSubnetRule).toArray(IPMapping.SubnetRule[]::new);
    }

    private static IPMapping.SubnetRule convertSubnetRule(IeIPCustomizationRule ieRule) {
        IPMapping.SubnetRule rule = new IPMapping.SubnetRule();
        rule.setDnsSuffixes(ieRule.getDnsSuffixes());
        rule.setLocalSubnet(ieRule.getLocalSubnet());
        rule.setName(ieRule.getName());
        rule.setRemoteSubnet(ieRule.getRemoteSubnet());
        IeRuleIPSettings ieSettings = ieRule.getIpSettings();
        if (ieSettings == null || ArrayUtils.isEmpty((Object[])ieSettings.getDnsServerList()) && ArrayUtils.isEmpty((Object[])ieSettings.getGateway()) && StringUtils.isEmpty((String)ieSettings.getPrimaryWINS()) && StringUtils.isEmpty((String)ieSettings.getSecondaryWINS())) {
            return rule;
        }
        IPSettings settings = IpCustomizationRuleConverter.getDefaultIPSettings();
        settings.setDnsServerList(ieSettings.getDnsServerList());
        settings.setGateway(ieSettings.getGateway());
        if (StringUtils.isNotBlank((String)ieSettings.getPrimaryWINS())) {
            settings.setPrimaryWINS(ieSettings.getPrimaryWINS());
        }
        if (StringUtils.isNotBlank((String)ieSettings.getSecondaryWINS())) {
            settings.setSecondaryWINS(ieSettings.getSecondaryWINS());
        }
        rule.setRemoteIPSettings(settings);
        return rule;
    }

    private static IPSettings getDefaultIPSettings() {
        IPSettings settings = new IPSettings();
        FixedIp ip = new FixedIp();
        ip.ipAddress = "0.0.0.0";
        settings.setIp((IpGenerator)ip);
        return settings;
    }
}

