/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.mappings;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.mappings.IeMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeTestNetworkMapping;
import com.vmware.srm.client.impex.configurables.plans.IeRecoveryPlan;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.recovery.TestNetworkMapping;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.recovery.RECOVERY_PLAN;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryTestNetworkMappingConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecoveryTestNetworkMappingConverter.class);

    public static List<IeTestNetworkMapping> fromVmodl(ManagedObjectReference recoveryPlan, IeRecoveryPlan ieRecoveryPlan, PcResult pcResult) {
        Object[] networkMappings = ieRecoveryPlan.isRecoverySiteLocal() ? (TestNetworkMapping[])pcResult.getProperty(recoveryPlan, RECOVERY_PLAN.LOCAL_SETTINGS_.TEST_NETWORK_MAPPINGS) : (TestNetworkMapping[])pcResult.getProperty(recoveryPlan, RECOVERY_PLAN.REMOTE_SETTINGS_.TEST_NETWORK_MAPPINGS);
        if (ArrayUtils.isEmpty((Object[])networkMappings)) {
            return Collections.emptyList();
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return Arrays.stream(networkMappings).map(mapping -> new IeTestNetworkMapping(idBuilder.buildId(mapping.getKey()), idBuilder.buildId(mapping.getTestNetwork()))).filter(IeMapping::fromCurrentPair).collect(Collectors.toList());
    }

    public static TestNetworkMapping[] toVmodl(List<IeTestNetworkMapping> ieNetworks, InventoryExtractor.InventoryLookup inventory) {
        if (ieNetworks == null) {
            LOGGER.debug("IeTestNetworkMappings is null.");
            return null;
        }
        Object[] mappings = (TestNetworkMapping[])ieNetworks.stream().map(ieMapping -> RecoveryTestNetworkMappingConverter.convertTestNetworkMapping(ieMapping, inventory)).filter(Objects::nonNull).toArray(TestNetworkMapping[]::new);
        if (ArrayUtils.isEmpty((Object[])mappings)) {
            LOGGER.debug("TestNetworkMappings is empty or null.");
            return null;
        }
        return mappings;
    }

    private static TestNetworkMapping convertTestNetworkMapping(IeTestNetworkMapping ieMapping, InventoryExtractor.InventoryLookup inventory) {
        String primary = ieMapping.getPrimary();
        String secondary = ieMapping.getSecondary();
        ManagedObjectReference key = (ManagedObjectReference)inventory.get(primary);
        if (key == null) {
            LOGGER.warn("Test Network Mapping key with id {} not found", (Object)primary);
            return null;
        }
        ManagedObjectReference testNetwork = (ManagedObjectReference)inventory.get(secondary);
        if (testNetwork == null) {
            LOGGER.warn("Test Network with id {} not found", (Object)secondary);
            return null;
        }
        return new TestNetworkMapping(key, testNetwork);
    }
}

