/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.mappings;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.mappings.IeMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeResourceMapping;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePoolMappingsConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcePoolMappingsConverter.class);

    public static IeResourceMapping[] fromVmodl(InventoryMapperBase.ResourcePoolMapping[] resourcePoolMappings) {
        if (ArrayUtils.isEmpty((Object[])resourcePoolMappings)) {
            return new IeResourceMapping[0];
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return (IeResourceMapping[])Arrays.stream(resourcePoolMappings).map(mapping -> new IeResourceMapping(idBuilder.buildId(mapping.primaryObject), idBuilder.buildId(mapping.secondaryObject))).filter(IeMapping::fromCurrentPair).toArray(IeResourceMapping[]::new);
    }

    public static InventoryMapperBase.ResourcePoolMapping[] toVmodl(IeResourceMapping[] ieMappings, InventoryExtractor.InventoryLookup inventory) {
        if (ArrayUtils.isEmpty((Object[])ieMappings)) {
            return new InventoryMapperBase.ResourcePoolMapping[0];
        }
        return (InventoryMapperBase.ResourcePoolMapping[])Arrays.stream(ieMappings).map(ieMapping -> {
            String primaryId = ieMapping.getPrimary();
            ManagedObjectReference primary = (ManagedObjectReference)inventory.get(primaryId);
            if (primary == null) {
                LOGGER.warn("Primary resource mapping {} not found.", (Object)primaryId);
                return null;
            }
            String secondaryId = ieMapping.getSecondary();
            ManagedObjectReference secondary = (ManagedObjectReference)inventory.get(secondaryId);
            if (secondary == null) {
                LOGGER.warn("Secondary resource mapping {} not found.", (Object)secondaryId);
                return null;
            }
            LOGGER.info("Adding resource mapping with ids {} {}.", (Object)primaryId, (Object)secondaryId);
            return new InventoryMapperBase.ResourcePoolMapping(primary, secondary, null);
        }).filter(Objects::nonNull).toArray(InventoryMapperBase.ResourcePoolMapping[]::new);
    }
}

