/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.vmSettings;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.common.CalloutConverter;
import com.vmware.srm.client.impex.configurables.common.IeRecoveryCallout;
import com.vmware.srm.client.impex.configurables.vmSettings.IeIPSettings;
import com.vmware.srm.client.impex.configurables.vmSettings.IeNicInfo;
import com.vmware.srm.client.impex.configurables.vmSettings.IeVmSettings;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.vim.binding.dr.recovery.RecoverySettingsRepository;
import com.vmware.vim.binding.dr.recovery.VmRecoverySettings;
import com.vmware.vim.binding.dr.vimext.NicInfo;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.customization.DhcpIpGenerator;
import com.vmware.vim.binding.vim.vm.customization.DhcpIpV6Generator;
import com.vmware.vim.binding.vim.vm.customization.FixedIp;
import com.vmware.vim.binding.vim.vm.customization.FixedIpV6;
import com.vmware.vim.binding.vim.vm.customization.IPSettings;
import com.vmware.vim.binding.vim.vm.customization.IpGenerator;
import com.vmware.vim.binding.vim.vm.customization.IpV6Generator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmSettingsConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmSettingsConverter.class);

    public static List<IeVmSettings> fromVmodl(List<RecoverySettingsRepository.VmSettingsMapping> vmSettingMappings, InventoryExtractor.VmKeysLookup vmKeys) {
        if (CollectionUtils.isEmpty(vmSettingMappings)) {
            return Collections.emptyList();
        }
        return vmSettingMappings.stream().map(vmSettingMapping -> VmSettingsConverter.fromVmodl(vmSettingMapping, vmKeys)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Map<String, RecoverySettingsRepository.VmSettingsMapping> toVmodl(Collection<IeVmSettings> ieVmSettings, InventoryExtractor.VmKeysLookup vmKeys, Map<String, RecoverySettingsRepository.VmSettingsMapping> keyToSetting) {
        if (CollectionUtils.isEmpty(ieVmSettings)) {
            return Collections.emptyMap();
        }
        ImpexImportSrmContext context = ImpexImportSrmContext.get();
        HashMap<String, IeVmSettings> toConvert = new HashMap<String, IeVmSettings>();
        for (IeVmSettings ieVmSetting : ieVmSettings) {
            if (ieVmSetting == null) {
                LOGGER.warn("Skipping null VM Recovery settings.");
                continue;
            }
            String instanceUuid = (String)vmKeys.get(ieVmSetting.getId());
            if (instanceUuid == null) {
                String message = ImpexL10N.localize("vmSettings", context.names().getVm(ieVmSetting.getId()));
                LOGGER.warn(message);
                context.addError(message);
                continue;
            }
            if (toConvert.containsKey(instanceUuid)) {
                IeVmSettings removed = (IeVmSettings)toConvert.remove(instanceUuid);
                LOGGER.warn("Removing VMs with IDs '{}' and '{}' due to having same instance UUIDs: '{}'.", new Object[]{removed.getId(), ieVmSetting.getId(), instanceUuid});
                continue;
            }
            toConvert.put(instanceUuid, ieVmSetting);
        }
        return toConvert.entrySet().stream().map(entry -> VmSettingsConverter.toVmSettingsMapping(keyToSetting, (String)entry.getKey(), (IeVmSettings)entry.getValue(), vmKeys)).filter(vmSettingsMapping -> vmSettingsMapping.settings.status != null).collect(Collectors.toMap(RecoverySettingsRepository.VmSettingsMapping::getKey, Function.identity()));
    }

    private static IeVmSettings fromVmodl(RecoverySettingsRepository.VmSettingsMapping vmSettings, InventoryExtractor.VmKeysLookup vmKeys) {
        String id = (String)vmKeys.get(vmSettings.key);
        if (id == null) {
            LOGGER.warn("VM settings mapping id not found for key '{}'.", (Object)vmSettings.key);
            return null;
        }
        IeVmSettings ieVmSettings = new IeVmSettings();
        ieVmSettings.setId(id);
        VmRecoverySettings settings = vmSettings.settings;
        VmSettingsConverter.setBasicSettings(ieVmSettings, settings);
        VmSettingsConverter.setDependentVms(ieVmSettings, settings.dependentVmIds, vmKeys);
        VmSettingsConverter.setPowerOnCallouts(ieVmSettings, settings);
        VmSettingsConverter.setNics(ieVmSettings, settings);
        return ieVmSettings;
    }

    private static void setBasicSettings(IeVmSettings ieSettings, VmRecoverySettings settings) {
        ieSettings.setAllowMigration(settings.allowMigration);
        ieSettings.setCustomizationTimeout(settings.customizationTimeout);
        ieSettings.setPowerOffTimeout(settings.powerOffTimeout);
        ieSettings.setPowerOnDelay(settings.powerOnDelay);
        ieSettings.setPowerOnTimeout(settings.powerOnTimeout);
        ieSettings.setRecoveryPriority(settings.recoveryPriority);
        ieSettings.setSkipGuestShutdown(settings.skipGuestShutdown);
        ieSettings.setCustomizeIpSettings(settings.customizeIpSettings);
        ieSettings.setUseIPSubnetMapping(settings.useIPSubnetMapping);
        if (settings.finalPowerState != null) {
            IeVmSettings.PowerState ieFinalPowerState = null;
            switch (settings.finalPowerState) {
                case poweredOff: {
                    ieFinalPowerState = IeVmSettings.PowerState.poweredOff;
                    break;
                }
                case poweredOn: {
                    ieFinalPowerState = IeVmSettings.PowerState.poweredOn;
                    break;
                }
                case suspended: {
                    ieFinalPowerState = IeVmSettings.PowerState.suspended;
                }
            }
            ieSettings.setFinalPowerState(ieFinalPowerState);
        }
    }

    private static void setDependentVms(IeVmSettings ieSettings, String[] dependentVmIds, InventoryExtractor.VmKeysLookup vmKeys) {
        if (dependentVmIds == null) {
            return;
        }
        ieSettings.setDependentVms(Arrays.stream(dependentVmIds).filter(vmKeys::containsKey).map(vmKeys::get).collect(Collectors.toList()));
    }

    private static void setPowerOnCallouts(IeVmSettings ieSettings, VmRecoverySettings settings) {
        ieSettings.setPrePowerOnRecoveryCallouts(CalloutConverter.fromVmodl(settings.prePowerOnCallouts));
        ieSettings.setPostPowerOnRecoveryCallouts(CalloutConverter.fromVmodl(settings.postPowerOnCallouts));
    }

    private static void setNics(IeVmSettings ieSettings, VmRecoverySettings settings) {
        NicInfo[] localNics = settings.localNetworkInfo;
        ieSettings.setProtectedSiteNetworkInfo(VmSettingsConverter.convertNicInfo(localNics));
        NicInfo[] remoteNics = settings.remoteNetworkInfo;
        ieSettings.setRecoverySiteNetworkInfo(VmSettingsConverter.convertNicInfo(remoteNics));
    }

    private static IeNicInfo[] convertNicInfo(NicInfo[] nics) {
        if (nics == null) {
            return null;
        }
        return (IeNicInfo[])Arrays.stream(nics).map(nic -> {
            IeNicInfo ieNic = new IeNicInfo();
            VmSettingsConverter.setBasicNicInfo(ieNic, nic);
            IeIPSettings ieIpSettings = new IeIPSettings();
            IPSettings ipSettings = nic.ipSettings;
            VmSettingsConverter.setIpSettings(ieIpSettings, ipSettings);
            IpGenerator ipGenerator = ipSettings.ip;
            if (ipGenerator instanceof FixedIp) {
                ieIpSettings.setIpv4Address(((FixedIp)ipGenerator).ipAddress);
                ieIpSettings.setIpv4Type(IeIPSettings.ipGeneratorType.FixedIp);
            } else if (ipGenerator instanceof DhcpIpGenerator) {
                ieIpSettings.setIpv4Type(IeIPSettings.ipGeneratorType.DhcpIp);
            }
            if (ipSettings.ipV6Spec != null) {
                VmSettingsConverter.setIpV6Settings(ieIpSettings, ipSettings, nic);
            }
            ieNic.setIpSettings(ieIpSettings);
            return ieNic;
        }).toArray(IeNicInfo[]::new);
    }

    private static void setBasicNicInfo(IeNicInfo ieNic, NicInfo nic) {
        ieNic.setDeviceId(nic.deviceId);
        ieNic.setDnsSuffixes(nic.dnsSuffixes);
        ieNic.setMacAddress(nic.macAddress);
    }

    private static void setIpSettings(IeIPSettings ieIpSettings, IPSettings ipSettings) {
        ieIpSettings.setDnsDomain(ipSettings.dnsDomain);
        ieIpSettings.setDnsServerList(ipSettings.dnsServerList);
        ieIpSettings.setGateway(ipSettings.gateway);
        ieIpSettings.setPrimaryWINS(ipSettings.primaryWINS);
        ieIpSettings.setSecondaryWINS(ipSettings.secondaryWINS);
        ieIpSettings.setSubnetMask(ipSettings.subnetMask);
        if (ipSettings.netBIOS != null) {
            IeIPSettings.NetBIOSMode ieNetBiosMode = null;
            switch (ipSettings.netBIOS) {
                case enableNetBIOSViaDhcp: {
                    ieNetBiosMode = IeIPSettings.NetBIOSMode.enableNetBIOSViaDhcp;
                    break;
                }
                case enableNetBIOS: {
                    ieNetBiosMode = IeIPSettings.NetBIOSMode.enableNetBIOS;
                    break;
                }
                case disableNetBIOS: {
                    ieNetBiosMode = IeIPSettings.NetBIOSMode.disableNetBIOS;
                }
            }
            ieIpSettings.setNetBIOS(ieNetBiosMode);
        }
    }

    private static void setIpV6Settings(IeIPSettings ieIpSettings, IPSettings ipSettings, NicInfo nic) {
        ieIpSettings.setIpv6AddressSpecGateway(ipSettings.ipV6Spec.gateway);
        if (ArrayUtils.isEmpty((Object[])nic.ipSettings.ipV6Spec.ip)) {
            return;
        }
        IpV6Generator ipv6Generator = nic.ipSettings.ipV6Spec.ip[0];
        if (ipv6Generator instanceof FixedIpV6) {
            FixedIpV6 fixedIpV6 = (FixedIpV6)ipv6Generator;
            ieIpSettings.setIpv6Address(fixedIpV6.ipAddress);
            ieIpSettings.setIpv6SubnetPrefixLength(fixedIpV6.subnetMask);
            ieIpSettings.setIpv6Type(IeIPSettings.ipv6GeneratorType.FixedIpV6);
        } else if (ipv6Generator instanceof DhcpIpV6Generator) {
            ieIpSettings.setIpv6Type(IeIPSettings.ipv6GeneratorType.DhcpIpV6);
        }
    }

    private static RecoverySettingsRepository.VmSettingsMapping toVmSettingsMapping(Map<String, RecoverySettingsRepository.VmSettingsMapping> keyToSetting, String key, IeVmSettings ieSettings, InventoryExtractor.VmKeysLookup vmKeys) {
        VmRecoverySettings settings = new VmRecoverySettings();
        VmSettingsConverter.setBasicSettings(settings, ieSettings);
        VmSettingsConverter.setDependentVms(settings, ieSettings, vmKeys);
        VmSettingsConverter.setCurrentStatus(settings, keyToSetting, key);
        VmSettingsConverter.setPowerOnCallouts(settings, ieSettings);
        VmSettingsConverter.setNetworkInfo(settings, ieSettings);
        return new RecoverySettingsRepository.VmSettingsMapping(key, settings);
    }

    private static void setBasicSettings(VmRecoverySettings settings, IeVmSettings ieSettings) {
        settings.setAllowMigration(ieSettings.isAllowMigration());
        settings.setCustomizationTimeout(ieSettings.getCustomizationTimeout());
        settings.setPowerOffTimeout(ieSettings.getPowerOffTimeout());
        settings.setPowerOnDelay(ieSettings.getPowerOnDelay());
        settings.setPowerOnTimeout(ieSettings.getPowerOnTimeout());
        settings.setRecoveryPriority(ieSettings.getRecoveryPriority());
        settings.setSkipGuestShutdown(ieSettings.isSkipGuestShutdown());
        settings.setUseIPSubnetMapping(ieSettings.getUseIPSubnetMapping());
        settings.setCustomizeIpSettings(ieSettings.isCustomizeIpSettings());
        IeVmSettings.PowerState ieFinalPowerState = ieSettings.getFinalPowerState();
        if (ieFinalPowerState != null) {
            VirtualMachine.PowerState finalPowerState = null;
            switch (ieFinalPowerState) {
                case poweredOff: {
                    finalPowerState = VirtualMachine.PowerState.poweredOff;
                    break;
                }
                case poweredOn: {
                    finalPowerState = VirtualMachine.PowerState.poweredOn;
                    break;
                }
                case suspended: {
                    finalPowerState = VirtualMachine.PowerState.suspended;
                }
            }
            settings.setFinalPowerState(finalPowerState);
        }
    }

    private static void setDependentVms(VmRecoverySettings settings, IeVmSettings ieSettings, InventoryExtractor.VmKeysLookup vmKeys) {
        List<String> dependentVms = ieSettings.getDependentVms();
        if (dependentVms == null) {
            LOGGER.debug("Dependent VMs are null.");
            return;
        }
        Object[] dependentVmKeys = (String[])dependentVms.stream().filter(vmKeys::containsKey).map(vmKeys::get).toArray(String[]::new);
        if (ArrayUtils.isNotEmpty((Object[])dependentVmKeys)) {
            settings.setDependentVmIds((String[])dependentVmKeys);
        }
    }

    private static void setCurrentStatus(VmRecoverySettings settings, Map<String, RecoverySettingsRepository.VmSettingsMapping> vmSettingMap, String identity) {
        RecoverySettingsRepository.VmSettingsMapping mapping = vmSettingMap.get(identity);
        if (mapping == null) {
            LOGGER.debug("VmSettingMapping is null, for identity: {}.", (Object)identity);
            return;
        }
        VmRecoverySettings serverSettings = mapping.settings;
        settings.setStatus(serverSettings.status);
        settings.setChangeVersion(serverSettings.changeVersion);
        settings.setLocalFaultToleranceState(serverSettings.localFaultToleranceState);
        settings.setRemoteFaultToleranceState(serverSettings.remoteFaultToleranceState);
    }

    private static void setPowerOnCallouts(VmRecoverySettings settings, IeVmSettings ieSettings) {
        List<IeRecoveryCallout> prePowerOnCommands = ieSettings.getPrePowerOnRecoveryCallouts();
        settings.setPrePowerOnCallouts(CalloutConverter.toVmodl(prePowerOnCommands));
        List<IeRecoveryCallout> postPowerOnCommands = ieSettings.getPostPowerOnRecoveryCallouts();
        settings.setPostPowerOnCallouts(CalloutConverter.toVmodl(postPowerOnCommands));
    }

    private static void setNetworkInfo(VmRecoverySettings settings, IeVmSettings ieSettings) {
        settings.setLocalNetworkInfo(VmSettingsConverter.convertNicInfo(ieSettings.getRecoverySiteNetworkInfo()));
        settings.setRemoteNetworkInfo(VmSettingsConverter.convertNicInfo(ieSettings.getProtectedSiteNetworkInfo()));
    }

    private static NicInfo[] convertNicInfo(IeNicInfo[] ieNicInfos) {
        if (ieNicInfos == null) {
            LOGGER.debug("IeNicInfos are null.");
            return null;
        }
        return (NicInfo[])Arrays.stream(ieNicInfos).map(VmSettingsConverter::convertNicInfo).toArray(NicInfo[]::new);
    }

    private static NicInfo convertNicInfo(IeNicInfo ieNicInfo) {
        NicInfo nicInfo = new NicInfo();
        VmSettingsConverter.setBasicNicInfo(nicInfo, ieNicInfo);
        IeIPSettings ieSettings = ieNicInfo.getIpSettings();
        if (ieSettings != null) {
            IPSettings settings = new IPSettings();
            VmSettingsConverter.setIpSettings(settings, ieSettings);
            VmSettingsConverter.setIpv4Settings(settings, ieSettings);
            VmSettingsConverter.setIpV6Settings(settings, ieSettings);
            nicInfo.setIpSettings(settings);
        }
        return nicInfo;
    }

    private static void setBasicNicInfo(NicInfo nicInfo, IeNicInfo ieNic) {
        nicInfo.setDeviceId(ieNic.getDeviceId());
        nicInfo.setDnsSuffixes(ieNic.getDnsSuffixes());
        if (ieNic.getMacAddress() == null) {
            nicInfo.setMacAddress("");
        } else {
            nicInfo.setMacAddress(ieNic.getMacAddress());
        }
    }

    private static void setIpSettings(IPSettings settings, IeIPSettings ieSettings) {
        settings.setDnsDomain(ieSettings.getDnsDomain());
        settings.setDnsServerList(ieSettings.getDnsServerList());
        settings.setGateway(ieSettings.getGateway());
        settings.setPrimaryWINS(ieSettings.getPrimaryWINS());
        settings.setSecondaryWINS(ieSettings.getSecondaryWINS());
        settings.setSubnetMask(ieSettings.getSubnetMask());
        IeIPSettings.NetBIOSMode ieNetBIOS = ieSettings.getNetBIOS();
        if (ieNetBIOS != null) {
            IPSettings.NetBIOSMode netBiosMode = null;
            switch (ieNetBIOS) {
                case enableNetBIOSViaDhcp: {
                    netBiosMode = IPSettings.NetBIOSMode.enableNetBIOSViaDhcp;
                    break;
                }
                case enableNetBIOS: {
                    netBiosMode = IPSettings.NetBIOSMode.enableNetBIOS;
                    break;
                }
                case disableNetBIOS: {
                    netBiosMode = IPSettings.NetBIOSMode.disableNetBIOS;
                }
            }
            settings.setNetBIOS(netBiosMode);
        }
    }

    private static void setIpv4Settings(IPSettings settings, IeIPSettings ieSettings) {
        if (ieSettings.getIpv4Type() == null) {
            settings.setIp(new IpGenerator());
            return;
        }
        switch (ieSettings.getIpv4Type()) {
            case FixedIp: {
                FixedIp ip = new FixedIp();
                ip.setIpAddress(ieSettings.getIpv4Address());
                settings.setIp((IpGenerator)ip);
                break;
            }
            case DhcpIp: {
                settings.setIp((IpGenerator)new DhcpIpGenerator());
                break;
            }
            default: {
                settings.setIp(new IpGenerator());
            }
        }
    }

    private static void setIpV6Settings(IPSettings settings, IeIPSettings ieSettings) {
        if (ieSettings.getIpv6Type() == null) {
            LOGGER.debug("IPV6 is null.");
            return;
        }
        IPSettings.IpV6AddressSpec ipV6AddressSpec = new IPSettings.IpV6AddressSpec();
        ipV6AddressSpec.setGateway(ieSettings.getIpv6AddressSpecGateway());
        settings.setIpV6Spec(ipV6AddressSpec);
        switch (ieSettings.getIpv6Type()) {
            case FixedIpV6: {
                FixedIpV6 fixedIpV6 = new FixedIpV6();
                fixedIpV6.setIpAddress(ieSettings.getIpv6Address());
                fixedIpV6.setSubnetMask(ieSettings.getIpv6SubnetPrefixLength().intValue());
                settings.ipV6Spec.setIp(new IpV6Generator[]{fixedIpV6});
                break;
            }
            case DhcpIpV6: {
                settings.ipV6Spec.setIp(new IpV6Generator[]{new DhcpIpV6Generator()});
                break;
            }
            default: {
                settings.getIpV6Spec().setIp(new IpV6Generator[]{new IpV6Generator()});
            }
        }
        settings.setIpV6Spec(ipV6AddressSpec);
    }
}

