/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders.groups.vm;

import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupProperties;
import com.vmware.srm.client.impex.configurables.groups.recovery.IeRecoveryLocationSettings;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.IeDeviceBackingLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.IeDeviceInfo;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.datastoreLocator.IeDatastoreLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.datastoreLocator.IeExistingDatastoreLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.datastoreLocator.IeHbrDatastoreLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.diskBacking.IeDiskBackingLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.diskBacking.IeRdmBackingLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.fileBacking.IeCreateOptions;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.fileBacking.IeDirectoryLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.fileBacking.IeFileDeviceBackingLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.fileBacking.IeVmFileLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.hbrBacking.IeHbrBackingLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.networkBacking.IeExNetworkDeviceBackingLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.networkBacking.IeNetworkDeviceBackingLocator;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.networkBacking.IeVxwNetworkDeviceBackingLocator;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.vim.binding.dr.replication.ProtectedVm;
import com.vmware.vim.binding.dr.vimext.DatastoreLocator;
import com.vmware.vim.binding.dr.vimext.DeviceBackingLocator;
import com.vmware.vim.binding.dr.vimext.DeviceInfo;
import com.vmware.vim.binding.dr.vimext.DirectoryLocator;
import com.vmware.vim.binding.dr.vimext.DiskBackingLocator;
import com.vmware.vim.binding.dr.vimext.ExNetworkDeviceBackingLocator;
import com.vmware.vim.binding.dr.vimext.ExistingDatastoreLocator;
import com.vmware.vim.binding.dr.vimext.FileDeviceBackingLocator;
import com.vmware.vim.binding.dr.vimext.HbrBackingLocator;
import com.vmware.vim.binding.dr.vimext.HbrDatastoreLocator;
import com.vmware.vim.binding.dr.vimext.NetworkDeviceBackingLocator;
import com.vmware.vim.binding.dr.vimext.RdmBackingLocator;
import com.vmware.vim.binding.dr.vimext.VmFileLocator;
import com.vmware.vim.binding.dr.vimext.VxwNetworkDeviceBackingLocator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryLocationSettingsConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecoveryLocationSettingsConverter.class);
    private final InventoryExtractor.InventoryLookup _inventory;

    public RecoveryLocationSettingsConverter(InventoryExtractor.InventoryLookup inventory) {
        this._inventory = inventory;
    }

    public void setRecoveryLocationSettings(ProtectedVm.RecoveryLocationSettings recoverySettings, IeVmProtectionGroupProperties properties) {
        IeRecoveryLocationSettings ieSettings = properties.getRecoverySettings();
        if (ieSettings == null) {
            LOGGER.debug("IeSettings are empty or null for id: '{}'.", (Object)properties.getId());
            return;
        }
        recoverySettings.setExcludedDeviceKey(ieSettings.getExcludedDevices());
        IeDeviceInfo[] ieDeviceInfos = ieSettings.getDeviceInfos();
        if (ieDeviceInfos == null) {
            LOGGER.debug("IeDeviceInfos are empty or null for id: '{}'.", (Object)properties.getId());
            return;
        }
        Object[] deviceInfos = this.convertDeviceInfos(ieDeviceInfos, properties.getId());
        if (ArrayUtils.isEmpty((Object[])deviceInfos)) {
            LOGGER.debug("DeviceInfos are empty or null for id: '{}'.", (Object)properties.getId());
            return;
        }
        recoverySettings.setProtectedDevice((DeviceInfo[])deviceInfos);
    }

    public void reconfigureNetworkDeviceBackingLocator(IeDeviceBackingLocator ieLocator, NetworkDeviceBackingLocator networkLocatorToReconfigure) {
        this.configureNetworkDeviceBackingLocator(ieLocator, networkLocatorToReconfigure);
    }

    public DeviceInfo[] convertDeviceInfos(IeDeviceInfo[] ieDeviceInfos, String ieVmPgId) {
        if (ieDeviceInfos == null) {
            LOGGER.debug("IeDeviceInfos are empty or null for id: '{}'.", (Object)ieVmPgId);
            return null;
        }
        DeviceInfo[] deviceInfos = (DeviceInfo[])Arrays.stream(ieDeviceInfos).map(ieDeviceInfo -> {
            try {
                DeviceInfo deviceInfo = this.convertDeviceInfo((IeDeviceInfo)ieDeviceInfo);
                if (deviceInfo != null) {
                    return deviceInfo;
                }
                LOGGER.debug("IeDeviceInfo is null for id: '{}'.", (Object)ieVmPgId);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create DeviceInfo", (Throwable)e);
            }
            return null;
        }).filter(Objects::nonNull).toArray(DeviceInfo[]::new);
        return deviceInfos;
    }

    private DeviceInfo convertDeviceInfo(IeDeviceInfo ieDeviceInfo) {
        if (ieDeviceInfo == null) {
            return null;
        }
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setKey(ieDeviceInfo.getKey());
        IeDeviceBackingLocator ieLocator = ieDeviceInfo.getLocator();
        if (ieLocator instanceof IeDiskBackingLocator) {
            deviceInfo.setBacking((DeviceBackingLocator)this.convertDiskBackingLocator(ieLocator));
        } else if (ieLocator instanceof IeFileDeviceBackingLocator) {
            deviceInfo.setBacking((DeviceBackingLocator)this.convertFileDeviceBackingLocator((IeFileDeviceBackingLocator)ieLocator));
        } else if (ieLocator instanceof IeHbrBackingLocator) {
            deviceInfo.setBacking((DeviceBackingLocator)this.convertHbrBackingLocator());
        } else if (ieLocator instanceof IeNetworkDeviceBackingLocator) {
            deviceInfo.setBacking((DeviceBackingLocator)this.convertNetworkDeviceBackingLocator(ieLocator));
        }
        return deviceInfo;
    }

    private DiskBackingLocator convertDiskBackingLocator(IeDeviceBackingLocator ieLocator) {
        if (ieLocator instanceof IeRdmBackingLocator) {
            IeRdmBackingLocator rdmLocator = (IeRdmBackingLocator)ieLocator;
            RdmBackingLocator backingLocator = new RdmBackingLocator();
            IeDatastoreLocator[] ieDatastoreLocators = rdmLocator.getDatastoreLocators();
            Object[] datastoreLocators = this.getDatastoreLocators(ieDatastoreLocators);
            if (ArrayUtils.isNotEmpty((Object[])datastoreLocators)) {
                backingLocator.setDatastore((DatastoreLocator[])datastoreLocators);
            }
            return backingLocator;
        }
        if (ieLocator instanceof IeDiskBackingLocator) {
            IeDiskBackingLocator ieDiskLocator = (IeDiskBackingLocator)ieLocator;
            DiskBackingLocator diskLocator = new DiskBackingLocator();
            IeDatastoreLocator[] ieDatastoreLocators = ieDiskLocator.getDatastoreLocators();
            Object[] datastoreLocators = this.getDatastoreLocators(ieDatastoreLocators);
            if (ArrayUtils.isNotEmpty((Object[])datastoreLocators)) {
                diskLocator.setDatastore((DatastoreLocator[])datastoreLocators);
            }
            return diskLocator;
        }
        throw new IllegalStateException("Unexpected device locator type" + ieLocator);
    }

    private DatastoreLocator[] getDatastoreLocators(IeDatastoreLocator[] ieDatastoreLocators) {
        if (ieDatastoreLocators == null) {
            LOGGER.debug("IeDatastoreLocators are null.");
            return null;
        }
        return (DatastoreLocator[])Arrays.stream(ieDatastoreLocators).map(this::convertDatastoreLocator).filter(Objects::nonNull).toArray(DatastoreLocator[]::new);
    }

    private FileDeviceBackingLocator convertFileDeviceBackingLocator(IeFileDeviceBackingLocator ieFileLocator) {
        FileDeviceBackingLocator fileLocator = new FileDeviceBackingLocator();
        IeCreateOptions ieCreateOptions = ieFileLocator.getCreateOptions();
        fileLocator.setCreateOptions(this.convertCreateOptions(ieCreateOptions));
        IeVmFileLocator ieVmFileLocator = ieFileLocator.getFileLocator();
        VmFileLocator vmFileLocator = this.convertVmFileLocator(ieVmFileLocator);
        if (vmFileLocator == null) {
            return null;
        }
        fileLocator.setLocation(vmFileLocator);
        return fileLocator;
    }

    private FileDeviceBackingLocator.CreateOptions convertCreateOptions(IeCreateOptions ieCreateOptions) {
        if (ieCreateOptions == null) {
            LOGGER.debug("IeCreateOptions is null.");
            return null;
        }
        long capacity = ieCreateOptions.getCapacity();
        return new FileDeviceBackingLocator.CreateOptions(capacity);
    }

    private VmFileLocator convertVmFileLocator(IeVmFileLocator ieVmFileLocator) {
        if (ieVmFileLocator == null) {
            LOGGER.debug("IeVmFileLocator is null.");
            return null;
        }
        VmFileLocator vmFileLocator = new VmFileLocator();
        vmFileLocator.setFileName(ieVmFileLocator.getFileName());
        IeDirectoryLocator ieDirectoryLocator = ieVmFileLocator.getDirectoryLocator();
        vmFileLocator.setDirectory(this.convertDirectoryLocator(ieDirectoryLocator));
        return vmFileLocator;
    }

    private DirectoryLocator convertDirectoryLocator(IeDirectoryLocator ieDirectoryLocator) {
        if (ieDirectoryLocator == null) {
            LOGGER.debug("IeDirectoryLocator is null");
            return null;
        }
        DirectoryLocator directoryLocator = new DirectoryLocator();
        directoryLocator.setPath(ieDirectoryLocator.getPath());
        IeDatastoreLocator ieDatastoreLocator = ieDirectoryLocator.getDatastoreLocator();
        directoryLocator.setDatastore(this.convertDatastoreLocator(ieDatastoreLocator));
        return directoryLocator;
    }

    private DatastoreLocator convertDatastoreLocator(IeDatastoreLocator ieDatastoreLocator) {
        if (ieDatastoreLocator == null) {
            LOGGER.debug("IeDatastoreLocator is null.");
            return null;
        }
        if (ieDatastoreLocator instanceof IeHbrDatastoreLocator) {
            return new HbrDatastoreLocator();
        }
        if (ieDatastoreLocator instanceof IeExistingDatastoreLocator) {
            IeExistingDatastoreLocator existingDatastoreLocator = (IeExistingDatastoreLocator)ieDatastoreLocator;
            String datastore = existingDatastoreLocator.getDatastore();
            ManagedObjectReference datastoreMoRef = (ManagedObjectReference)this._inventory.get(datastore);
            if (datastoreMoRef == null) {
                throw new RuntimeException("Unable to find datastore: " + datastore);
            }
            return new ExistingDatastoreLocator(datastoreMoRef);
        }
        LOGGER.debug("Unhandled IeDatastoreLocator type: '{}'.", (Object)ieDatastoreLocator);
        return null;
    }

    private HbrBackingLocator convertHbrBackingLocator() {
        return new HbrBackingLocator();
    }

    private NetworkDeviceBackingLocator convertNetworkDeviceBackingLocator(IeDeviceBackingLocator ieLocator) {
        return this.configureNetworkDeviceBackingLocator(ieLocator, null);
    }

    private NetworkDeviceBackingLocator configureNetworkDeviceBackingLocator(IeDeviceBackingLocator ieLocator, NetworkDeviceBackingLocator currentNetworkLocator) {
        if (ieLocator == null) {
            LOGGER.debug("IeLocator is null.");
            return null;
        }
        if (ieLocator instanceof IeVxwNetworkDeviceBackingLocator) {
            IeVxwNetworkDeviceBackingLocator ieNetworkLocator = (IeVxwNetworkDeviceBackingLocator)ieLocator;
            VxwNetworkDeviceBackingLocator vxwNetworkLocator = currentNetworkLocator != null ? (VxwNetworkDeviceBackingLocator)currentNetworkLocator : new VxwNetworkDeviceBackingLocator();
            this.setVxwNetworkDeviceBackingLocator(ieNetworkLocator, vxwNetworkLocator);
            return vxwNetworkLocator;
        }
        if (ieLocator instanceof IeExNetworkDeviceBackingLocator) {
            IeExNetworkDeviceBackingLocator ieNetworkLocator = (IeExNetworkDeviceBackingLocator)ieLocator;
            ExNetworkDeviceBackingLocator exNetworkLocator = currentNetworkLocator != null ? (ExNetworkDeviceBackingLocator)currentNetworkLocator : new ExNetworkDeviceBackingLocator();
            this.setExNetworkDeviceBackingLocator(ieNetworkLocator, exNetworkLocator);
            return exNetworkLocator;
        }
        if (ieLocator instanceof IeNetworkDeviceBackingLocator) {
            IeNetworkDeviceBackingLocator ieNetworkLocator = (IeNetworkDeviceBackingLocator)ieLocator;
            NetworkDeviceBackingLocator networkLocator = currentNetworkLocator != null ? currentNetworkLocator : new NetworkDeviceBackingLocator();
            this.setNetworkDeviceBackingLocator(ieNetworkLocator, networkLocator);
            return networkLocator;
        }
        LOGGER.debug("Unhandled IeLocator type: '{}'.", ieLocator.getClass());
        return null;
    }

    private void setVxwNetworkDeviceBackingLocator(IeVxwNetworkDeviceBackingLocator ieNetworkLocator, VxwNetworkDeviceBackingLocator networkLocator) {
        this.setExNetworkDeviceBackingLocator(ieNetworkLocator, (ExNetworkDeviceBackingLocator)networkLocator);
        networkLocator.setLogicalSwitchId(ieNetworkLocator.getLogicalSwitchId());
    }

    private void setExNetworkDeviceBackingLocator(IeExNetworkDeviceBackingLocator ieNetworkLocator, ExNetworkDeviceBackingLocator networkLocator) {
        this.setNetworkDeviceBackingLocator(ieNetworkLocator, (NetworkDeviceBackingLocator)networkLocator);
        networkLocator.setName(ieNetworkLocator.getName());
    }

    private void setNetworkDeviceBackingLocator(IeNetworkDeviceBackingLocator ieNetworkLocator, NetworkDeviceBackingLocator networkLocator) {
        String network = ieNetworkLocator.getNetwork();
        networkLocator.setNetwork(this.getNetwork(network));
    }

    private ManagedObjectReference getNetwork(String networkId) {
        if (networkId == null) {
            return null;
        }
        ManagedObjectReference network = (ManagedObjectReference)this._inventory.get(networkId);
        if (network == null) {
            ImpexImportSrmContext context = ImpexImportSrmContext.get();
            String message = ImpexL10N.localize("group.protectVms.network", context.names().getNetwork(networkId));
            LOGGER.warn(message);
            context.addError(message);
        }
        return network;
    }
}

