/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi;

import com.vmware.vapi.Message;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.l10n.StringFormatTemplateFormatter;
import com.vmware.vapi.l10n.TemplateFormatter;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;

public final class MessageFactory {
    private static MessageFactory defaultFactory;
    private ResourceBundle resBundle;
    private TemplateFormatter formatter;

    public MessageFactory(ResourceBundle resBundle, TemplateFormatter formatter) {
        Validate.notNull(resBundle);
        Validate.notNull(formatter);
        this.resBundle = resBundle;
        this.formatter = formatter;
    }

    public MessageFactory(ResourceBundle resBundle) {
        this(resBundle, new StringFormatTemplateFormatter());
    }

    public static Message getMessage(String id, String ... args) {
        return defaultFactory.buildMessage(id, args);
    }

    public Message buildMessage(String id, String ... args) {
        if (this.resBundle.containsKey(id)) {
            return new Message(id, this.buildDefaultMessage(this.resBundle.getString(id), this.resBundle.getLocale(), args), args);
        }
        return this.buildUnavailableMessage(id, args);
    }

    String buildDefaultMessage(String msgTemplate, Locale locale, String ... args) {
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return this.formatter.format(msgTemplate, Arrays.asList(args), locale);
    }

    Message buildUnavailableMessage(String id, String ... args) {
        return new Message("vapi.message.unknown", String.format("Unknown message ID requested %s with parameters %s", id, Arrays.toString(args)), new String[0]);
    }

    static {
        ResourceBundle runtimeBundle = ResourceBundle.getBundle("runtime");
        defaultFactory = new MessageFactory(runtimeBundle);
    }
}

