/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings.client;

import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.std.Progress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncCallbackFuture<T>
extends AsyncCallback<T>
implements Future<T> {
    private final Lock lock = new ReentrantLock();
    private final Condition set = this.lock.newCondition();
    private boolean completed = false;
    private T result;
    private RuntimeException error;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.completed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            while (!this.completed) {
                this.set.await();
            }
            if (this.error == null) {
                T t = this.result;
                return t;
            }
            throw new ExecutionException(this.error);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.lock.lock();
        try {
            while (!this.completed) {
                boolean signalled = this.set.await(timeout, unit);
                if (signalled) continue;
                throw new TimeoutException();
            }
            if (this.error == null) {
                T t = this.result;
                return t;
            }
            throw new ExecutionException(this.error);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onProgress(Progress progress) {
    }

    @Override
    public void onResult(T result) {
        this.lock.lock();
        try {
            this.result = result;
            this.completed = true;
            this.set.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onError(RuntimeException error) {
        this.lock.lock();
        try {
            this.error = error;
            this.completed = true;
            this.set.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

